/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.core.conditions.AbstractObjectConditions;
import org.fluentlenium.core.conditions.ListIntegerConditions;
import org.fluentlenium.core.conditions.Negation;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;

public class DynamicIntegerConditionsImpl
extends AbstractObjectConditions<List<? extends FluentWebElement>>
implements ListIntegerConditions {
    public DynamicIntegerConditionsImpl(Supplier<List<? extends FluentWebElement>> supplier, boolean negation) {
        super(supplier.get(), negation);
    }

    @Override
    protected AbstractObjectConditions<List<? extends FluentWebElement>> newInstance(boolean negationValue) {
        return new DynamicIntegerConditionsImpl(() -> (List)this.object, negationValue);
    }

    @Override
    @Negation
    public DynamicIntegerConditionsImpl not() {
        return (DynamicIntegerConditionsImpl)super.not();
    }

    @Override
    public boolean equalTo(int value) {
        return this.verify(input -> this.getListSize(input) == value);
    }

    @Override
    public boolean lessThan(int value) {
        return this.verify(input -> this.getListSize(input) < value);
    }

    @Override
    public boolean lessThanOrEqualTo(int value) {
        return this.verify(input -> this.getListSize(input) <= value);
    }

    @Override
    public boolean greaterThan(int value) {
        return this.verify(input -> this.getListSize(input) > value);
    }

    @Override
    public boolean greaterThanOrEqualTo(int value) {
        return this.verify(input -> this.getListSize(input) >= value);
    }

    private <T extends List> int getListSize(T input) {
        if (input instanceof FluentList) {
            return ((FluentList)input).count();
        }
        return input.size();
    }
}

