/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.switchto.FluentTargetLocator;
import org.fluentlenium.core.switchto.FluentTargetLocatorImpl;
import org.fluentlenium.core.wait.FluentWait;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;

public class WindowAction {
    private final FluentControl fluentControl;
    private final ComponentInstantiator instantiator;
    private final WebDriver driver;

    public WindowAction(FluentControl control, ComponentInstantiator instantiator, WebDriver driver) {
        this.driver = driver;
        this.instantiator = instantiator;
        this.fluentControl = control;
    }

    public String title() {
        return this.driver.getTitle();
    }

    public WindowAction maximize() {
        this.driver.manage().window().maximize();
        return this;
    }

    public WindowAction fullscreen() {
        this.driver.manage().window().fullscreen();
        return this;
    }

    public WindowAction setSize(Dimension size) {
        this.driver.manage().window().setSize(size);
        return this;
    }

    public Dimension getSize() {
        return this.driver.manage().window().getSize();
    }

    public WindowAction setPosition(Point position) {
        this.driver.manage().window().setPosition(position);
        return this;
    }

    public Point getPosition() {
        return this.driver.manage().window().getPosition();
    }

    public String clickAndOpenNew(FluentWebElement button) {
        String oldWindowHandle = this.driver.getWindowHandle();
        Set oldWindowHandles = this.driver.getWindowHandles();
        button.click();
        this.waitForNewWindowToOpen(oldWindowHandles);
        HashSet newWindowHandles = new HashSet(this.driver.getWindowHandles());
        newWindowHandles.removeAll(oldWindowHandles);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String newWindowHandle = (String)newWindowHandles.iterator().next();
        this.switchTo(newWindowHandle);
        return oldWindowHandle;
    }

    public String openNewAndSwitch() {
        Set oldWindowHandles = this.driver.getWindowHandles();
        String oldWindowHandle = this.driver.getWindowHandle();
        JavascriptExecutor jse = (JavascriptExecutor)this.driver;
        jse.executeScript("window.open('someUrl', '_blank')", new Object[0]);
        this.waitForNewWindowToOpen(oldWindowHandles);
        this.switchToLast(oldWindowHandle);
        return oldWindowHandle;
    }

    public void clickAndCloseCurrent(FluentWebElement button) {
        String currentWindowHandle = this.driver.getWindowHandle();
        button.click();
        this.fluentControl.await().untilWindow(currentWindowHandle).notDisplayed();
        this.switchToLast();
    }

    public void close() {
        this.driver.close();
    }

    public FluentTargetLocator<WindowAction> switchTo() {
        return new FluentTargetLocatorImpl<WindowAction>(this, this.instantiator, this.driver.switchTo());
    }

    public WindowAction switchToLast() {
        ArrayList windowHandles = new ArrayList(this.driver.getWindowHandles());
        this.driver.switchTo().window((String)windowHandles.get(windowHandles.size() - 1));
        return this;
    }

    public WindowAction switchToLast(String nameOrHandleToExclude) {
        ArrayList windowHandles = new ArrayList(this.driver.getWindowHandles());
        if (windowHandles.size() > 1) {
            windowHandles.remove(nameOrHandleToExclude);
        }
        this.driver.switchTo().window((String)windowHandles.get(windowHandles.size() - 1));
        return this;
    }

    public WindowAction switchTo(String nameOrHandle) {
        return this.switchTo().window(nameOrHandle);
    }

    public WebDriver.Window getWindow() {
        return this.driver.manage().window();
    }

    private void waitForNewWindowToOpen(Set<String> oldWindowHandles) {
        ((FluentWait)((FluentWait)this.fluentControl.await().atMost(10L, TimeUnit.SECONDS)).withMessage("Timed out waiting for new window to open.")).untilPredicate(new WindowHandlesCountIs(oldWindowHandles.size() + 1));
    }

    private class WindowHandlesCountIs
    implements Predicate<FluentControl> {
        private final int expectedValue;

        WindowHandlesCountIs(int expectedValue) {
            this.expectedValue = expectedValue;
        }

        @Override
        public boolean test(FluentControl fluentControl) {
            return WindowAction.this.driver.getWindowHandles().size() == this.expectedValue;
        }
    }
}

