/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import org.fluentlenium.core.DefaultFluentContainer;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentPageControl;
import org.fluentlenium.core.annotation.PageUrl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.page.ClassAnnotations;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.url.ParsedUrlTemplate;
import org.fluentlenium.core.url.UrlTemplate;
import org.fluentlenium.utils.UrlUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;

public class FluentPage
extends DefaultFluentContainer
implements FluentPageControl {
    private final ClassAnnotations classAnnotations = new ClassAnnotations(this.getClass());

    public FluentPage() {
    }

    public FluentPage(FluentControl control) {
        super(control);
    }

    public ClassAnnotations getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public String getUrl() {
        String url;
        if (this.getClass().isAnnotationPresent(PageUrl.class) && !(url = this.getPageUrlValue(this.getClass().getAnnotation(PageUrl.class))).isEmpty()) {
            return url;
        }
        return null;
    }

    private String getPageUrlValue(PageUrl pageUrl) {
        return (this.isLocalFile(pageUrl) ? UrlUtils.getAbsoluteUrlFromFile(pageUrl.file()) : "") + pageUrl.value();
    }

    private boolean isLocalFile(PageUrl pageUrl) {
        return pageUrl != null && !pageUrl.file().isEmpty();
    }

    private PageUrl getPageUrlAnnotation() {
        PageUrl annotation = null;
        if (this.getClass().isAnnotationPresent(PageUrl.class)) {
            annotation = this.getClass().getAnnotation(PageUrl.class);
        }
        return annotation;
    }

    @Override
    public String getUrl(Object ... parameters) {
        String url = this.getUrl();
        if (url == null) {
            return null;
        }
        UrlTemplate template = new UrlTemplate(url);
        for (Object parameter : parameters) {
            template.add(parameter == null ? null : String.valueOf(parameter));
        }
        return template.render();
    }

    @Override
    public void isAt() {
        String url;
        By by = this.classAnnotations.buildBy();
        if (by != null) {
            this.isAtUsingSelector(by);
        }
        if ((url = this.getUrl()) != null) {
            this.isAtUsingUrl(url);
        }
    }

    @Override
    public void isAt(Object ... parameters) {
        String url = this.getUrl(parameters);
        if (url != null) {
            this.isAtUsingUrl(url);
        }
    }

    public void isAtUsingUrl(String urlTemplate) {
        String url;
        UrlTemplate template;
        ParsedUrlTemplate parse;
        if (!this.isLocalFile(this.getPageUrlAnnotation()) && !(parse = (template = new UrlTemplate(urlTemplate)).parse(url = this.url())).matches()) {
            throw new AssertionError((Object)String.format("Current URL [%s] doesn't match expected Page URL [%s]", url, urlTemplate));
        }
    }

    public void isAtUsingSelector(By by) {
        try {
            ((FluentWebElement)this.$(by, new SearchFilter[0]).first()).now();
        }
        catch (NoSuchElementException | StaleElementReferenceException | TimeoutException e) {
            throw new AssertionError("@FindBy element not found for page " + this.getClass().getName(), e);
        }
    }

    @Override
    public <P extends FluentPage> P go() {
        String url = this.getUrl();
        if (url == null) {
            throw new IllegalStateException("An URL should be defined on the page. Use @PageUrl annotation or override getUrl() method.");
        }
        this.goTo(url);
        return (P)this;
    }

    @Override
    public <P extends FluentPage> P go(Object ... params) {
        String url = this.getUrl(params);
        if (url == null) {
            throw new IllegalStateException("An URL should be defined on the page. Use @PageUrl annotation or override getUrl() method.");
        }
        this.goTo(url);
        return (P)this;
    }

    @Override
    public ParsedUrlTemplate parseUrl() {
        return this.parseUrl(this.url());
    }

    @Override
    public ParsedUrlTemplate parseUrl(String url) {
        String templateUrl = this.getUrl();
        if (templateUrl == null) {
            throw new IllegalStateException("An URL should be defined on the page. Use @PageUrl annotation or override getUrl() method.");
        }
        UrlTemplate template = new UrlTemplate(templateUrl);
        ParsedUrlTemplate parse = template.parse(url);
        return parse;
    }
}

