/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter.sharedwebdriver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.fluentlenium.adapter.sharedwebdriver.ClassAndTestName;
import org.fluentlenium.adapter.sharedwebdriver.ClassAndTestNameWithThreadId;
import org.fluentlenium.adapter.sharedwebdriver.SharedWebDriver;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.WebDriver;

class SharedWebdriverSingletonImpl {
    private final Map<Class<?>, SharedWebDriver> classDrivers = new HashMap();
    private final Map<ClassAndTestName, SharedWebDriver> methodDrivers = new HashMap<ClassAndTestName, SharedWebDriver>();
    private final Map<ClassAndTestNameWithThreadId, SharedWebDriver> threadDrivers = new HashMap<ClassAndTestNameWithThreadId, SharedWebDriver>();
    private SharedWebDriver jvmDriver;

    SharedWebdriverSingletonImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> SharedWebDriver getOrCreateDriver(Supplier<WebDriver> webDriverFactory, Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            SharedWebDriver driver = this.getDriver(testClass, testName, driverLifecycle);
            if (driver == null) {
                driver = this.createDriver(webDriverFactory, testClass, testName, driverLifecycle);
                this.registerDriver(driver);
            }
            return driver;
        }
    }

    private <T> SharedWebDriver createDriver(Supplier<WebDriver> webDriverFactory, Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
        WebDriver webDriver = webDriverFactory.get();
        return new SharedWebDriver(webDriver, testClass, testName, driverLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDriver(SharedWebDriver driver) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            switch (driver.getDriverLifecycle()) {
                case JVM: {
                    this.jvmDriver = driver;
                    break;
                }
                case CLASS: {
                    this.classDrivers.put(driver.getTestClass(), driver);
                    break;
                }
                case THREAD: {
                    this.threadDrivers.put(new ClassAndTestNameWithThreadId(driver.getTestClass(), driver.getTestName(), Thread.currentThread().getId()), driver);
                    break;
                }
                default: {
                    this.methodDrivers.put(new ClassAndTestName(driver.getTestClass(), driver.getTestName()), driver);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> SharedWebDriver getDriver(Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            switch (driverLifecycle) {
                case JVM: {
                    return this.jvmDriver;
                }
                case CLASS: {
                    return this.classDrivers.get(testClass);
                }
                case THREAD: {
                    return this.threadDrivers.get(new ClassAndTestNameWithThreadId(testClass, testName, Thread.currentThread().getId()));
                }
            }
            return this.methodDrivers.get(new ClassAndTestName(testClass, testName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit(SharedWebDriver driver) {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            switch (driver.getDriverLifecycle()) {
                case JVM: {
                    this.quitJvmDriver(driver);
                    break;
                }
                case CLASS: {
                    this.quitClassDriver(driver);
                    break;
                }
                case THREAD: {
                    this.quitThreadDriver(driver);
                    break;
                }
                default: {
                    this.quitMethodDriver(driver);
                }
            }
        }
    }

    private void quitJvmDriver(SharedWebDriver driver) {
        if (this.jvmDriver == driver) {
            if (this.jvmDriver.getDriver() != null) {
                this.jvmDriver.getDriver().quit();
            }
            this.jvmDriver = null;
        }
    }

    private void quitMethodDriver(SharedWebDriver sharedWebDriver) {
        SharedWebDriver testDriver = this.methodDrivers.remove(new ClassAndTestName(sharedWebDriver.getTestClass(), sharedWebDriver.getTestName()));
        this.quitDriver(sharedWebDriver, testDriver);
    }

    private void quitClassDriver(SharedWebDriver sharedWebDriver) {
        SharedWebDriver classDriver = this.classDrivers.remove(sharedWebDriver.getTestClass());
        this.quitDriver(sharedWebDriver, classDriver);
    }

    private void quitThreadDriver(SharedWebDriver driver) {
        List<Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>> threadDriversToClose = this.getThreadDriversToClose(driver);
        threadDriversToClose.forEach(item -> this.closeThreadDriver(driver, (Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>)item));
    }

    private List<Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver>> getThreadDriversToClose(SharedWebDriver driver) {
        return this.threadDrivers.entrySet().stream().filter(entry -> ((ClassAndTestNameWithThreadId)entry.getKey()).testClass.equals(driver.getTestClass()) && ((ClassAndTestNameWithThreadId)entry.getKey()).testName.equals(driver.getTestName()) && ((SharedWebDriver)entry.getValue()).getDriver().equals(driver.getDriver())).collect(Collectors.toList());
    }

    private void closeThreadDriver(SharedWebDriver sharedWebDriver, Map.Entry<ClassAndTestNameWithThreadId, SharedWebDriver> item) {
        SharedWebDriver testThreadDriver = this.threadDrivers.remove(item.getKey());
        this.quitDriver(sharedWebDriver, testThreadDriver);
    }

    private void quitDriver(SharedWebDriver sharedWebDriver, SharedWebDriver testDriver) {
        if (testDriver == sharedWebDriver && testDriver.getDriver() != null) {
            testDriver.getDriver().quit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SharedWebDriver> getAllDrivers() {
        ArrayList<SharedWebDriver> drivers = new ArrayList<SharedWebDriver>();
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            if (this.jvmDriver != null) {
                drivers.add(this.jvmDriver);
            }
            drivers.addAll(this.classDrivers.values());
            drivers.addAll(this.threadDrivers.values());
            drivers.addAll(this.methodDrivers.values());
        }
        return Collections.unmodifiableList(drivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SharedWebDriver> getTestClassDrivers(Class<?> testClass) {
        ArrayList<SharedWebDriver> drivers = new ArrayList<SharedWebDriver>();
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            SharedWebDriver classDriver = this.classDrivers.get(testClass);
            if (classDriver != null) {
                drivers.add(classDriver);
            }
            drivers.addAll(this.getDrivers(testClass, this.methodDrivers));
            drivers.addAll(this.getDrivers(testClass, this.threadDrivers));
            return Collections.unmodifiableList(drivers);
        }
    }

    private List<SharedWebDriver> getDrivers(Class<?> testClass, Map<?, SharedWebDriver> webDrivers) {
        ArrayList<SharedWebDriver> drivers = new ArrayList<SharedWebDriver>();
        for (SharedWebDriver testDriver : webDrivers.values()) {
            if (testDriver.getTestClass() != testClass) continue;
            drivers.add(testDriver);
        }
        return drivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quitAll() {
        SharedWebdriverSingletonImpl sharedWebdriverSingletonImpl = this;
        synchronized (sharedWebdriverSingletonImpl) {
            if (this.jvmDriver != null) {
                this.jvmDriver.getDriver().quit();
                this.jvmDriver = null;
            }
            this.quitAllDrivers(this.classDrivers);
            this.quitAllDrivers(this.methodDrivers);
            this.quitAllDrivers(this.threadDrivers);
        }
    }

    private void quitAllDrivers(Map<?, SharedWebDriver> driverType) {
        Iterator<SharedWebDriver> testThreadDriversIterator = driverType.values().iterator();
        while (testThreadDriversIterator.hasNext()) {
            testThreadDriversIterator.next().getDriver().quit();
            testThreadDriversIterator.remove();
        }
    }
}

