/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.lang.reflect.Field;
import java.util.List;
import org.fluentlenium.core.inject.LabelAnnotations;
import org.fluentlenium.core.label.FluentLabelProvider;
import org.fluentlenium.core.page.ClassAnnotations;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.pagefactory.AbstractAnnotations;
import org.openqa.selenium.support.pagefactory.Annotations;

public class InjectionAnnotations
extends AbstractAnnotations
implements FluentLabelProvider {
    private final ClassAnnotations classAnnotations;
    private final Annotations fieldAnnotations;
    private final LabelAnnotations labelFieldAnnotations;

    private static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    private static Class<?> getEffectiveClass(Field field) {
        Class<?> effectiveClass;
        if (InjectionAnnotations.isList(field) && (effectiveClass = ReflectionUtils.getFirstGenericType(field)) != null) {
            return effectiveClass;
        }
        return field.getType();
    }

    public InjectionAnnotations(Field field) {
        this.classAnnotations = new ClassAnnotations(InjectionAnnotations.getEffectiveClass(field));
        this.fieldAnnotations = new Annotations(field);
        this.labelFieldAnnotations = new LabelAnnotations(field);
    }

    public By buildBy() {
        By fieldBy = this.fieldAnnotations.buildBy();
        By classBy = this.classAnnotations.buildBy();
        if (classBy != null && fieldBy instanceof ByIdOrName) {
            return classBy;
        }
        return fieldBy;
    }

    public boolean isLookupCached() {
        return this.classAnnotations.isLookupCached() || this.fieldAnnotations.isLookupCached();
    }

    @Override
    public String getLabel() {
        return this.labelFieldAnnotations.getLabel();
    }

    @Override
    public String[] getLabelHints() {
        return this.labelFieldAnnotations.getLabelHints();
    }
}

