/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.lang.reflect.InvocationTargetException;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.ContainerFluentControl;
import org.fluentlenium.core.inject.ContainerInstantiator;
import org.fluentlenium.core.inject.FluentInjectException;
import org.fluentlenium.utils.ReflectionUtils;

public class DefaultContainerInstantiator
implements ContainerInstantiator {
    private final FluentControl control;

    public DefaultContainerInstantiator(FluentControl control) {
        this.control = control;
    }

    @Override
    public <T> T newInstance(Class<T> cls, ContainerContext context) {
        try {
            return ReflectionUtils.newInstanceOptionalArgs(cls, new ContainerFluentControl(this.control, context));
        }
        catch (NoSuchMethodException e) {
            throw new FluentInjectException(cls.getName() + " is not a valid component class.", e);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new FluentInjectException(cls.getName() + " can't be instantiated.", e);
        }
    }
}

