/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.GetScreenshotAsListener;
import org.fluentlenium.core.events.ListenerPriority;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.OutputType;

class AnnotationGetScreenshotAsListener
implements GetScreenshotAsListener,
ListenerPriority {
    private final Method method;
    private final Object container;
    private final String annotationName;
    private final int priority;

    AnnotationGetScreenshotAsListener(Method method, Object container, String annotationName, int priority) {
        this.method = method;
        this.container = container;
        this.annotationName = annotationName;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected Function<Class<?>, Object> getArgsFunction(OutputType outputType) {
        return input -> {
            if (input.isAssignableFrom(OutputType.class)) {
                return outputType;
            }
            return null;
        };
    }

    protected Function<Class<?>, Object> getArgsFunction(OutputType outputType, Object o) {
        return input -> {
            if (input.isAssignableFrom(OutputType.class)) {
                return outputType;
            }
            if (input.isAssignableFrom(Object.class)) {
                return o;
            }
            return null;
        };
    }

    public void on(OutputType outputType) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(outputType), parameterTypes);
        this.invokeMethodByReflection(args);
    }

    public void on(OutputType outputType, Object o) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(outputType, o), parameterTypes);
        this.invokeMethodByReflection(args);
    }

    private void invokeMethodByReflection(Object[] args) {
        try {
            ReflectionUtils.invoke(this.method, this.container, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

