/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.fluentlenium.configuration.Configuration;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.FluentControlImpl;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.action.KeyboardActions;
import org.fluentlenium.core.action.MouseActions;
import org.fluentlenium.core.action.WindowAction;
import org.fluentlenium.core.alert.Alert;
import org.fluentlenium.core.alert.AlertImpl;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.css.CssControl;
import org.fluentlenium.core.css.CssControlImpl;
import org.fluentlenium.core.css.CssSupport;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.ComponentsEventsRegistry;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.DefaultContainerInstantiator;
import org.fluentlenium.core.inject.FluentInjector;
import org.fluentlenium.core.script.FluentJavascript;
import org.fluentlenium.core.search.Search;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.wait.FluentWait;
import org.fluentlenium.utils.ImageUtils;
import org.fluentlenium.utils.UrlUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.support.events.EventFiringWebDriver;

public class FluentDriver
extends FluentControlImpl
implements FluentControl {
    private final Configuration configuration;
    private final ComponentsManager componentsManager;
    private final EventsRegistry events;
    private final ComponentsEventsRegistry componentsEventsRegistry;
    private final FluentInjector fluentInjector;
    private final CssControl cssControl;
    private final Search search;
    private final WebDriver driver;
    private final MouseActions mouseActions;
    private final KeyboardActions keyboardActions;
    private final WindowAction windowAction;

    public FluentDriver(WebDriver driver, Configuration configuration, FluentControl adapter) {
        super(adapter);
        this.configuration = configuration;
        this.componentsManager = new ComponentsManager(adapter);
        this.driver = driver;
        this.search = new Search((SearchContext)driver, this, this.componentsManager, adapter);
        if (driver instanceof EventFiringWebDriver) {
            this.events = new EventsRegistry(this);
            this.componentsEventsRegistry = new ComponentsEventsRegistry(this.events, this.componentsManager);
        } else {
            this.events = null;
            this.componentsEventsRegistry = null;
        }
        this.mouseActions = new MouseActions(driver);
        this.keyboardActions = new KeyboardActions(driver);
        this.fluentInjector = new FluentInjector(adapter, this.events, this.componentsManager, new DefaultContainerInstantiator(this));
        this.cssControl = new CssControlImpl(adapter, adapter);
        this.windowAction = new WindowAction(adapter, this.componentsManager.getInstantiator(), driver);
        this.configureDriver();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private ComponentsManager getComponentsManager() {
        return this.componentsManager;
    }

    private FluentInjector getFluentInjector() {
        return this.fluentInjector;
    }

    private CssControl getCssControl() {
        return this.cssControl;
    }

    private void configureDriver() {
        if (this.getDriver() != null && this.getDriver().manage() != null && this.getDriver().manage().timeouts() != null) {
            if (this.configuration.getPageLoadTimeout() != null) {
                this.getDriver().manage().timeouts().pageLoadTimeout(this.configuration.getPageLoadTimeout().longValue(), TimeUnit.MILLISECONDS);
            }
            if (this.configuration.getImplicitlyWait() != null) {
                this.getDriver().manage().timeouts().implicitlyWait(this.configuration.getImplicitlyWait().longValue(), TimeUnit.MILLISECONDS);
            }
            if (this.configuration.getScriptTimeout() != null) {
                this.getDriver().manage().timeouts().setScriptTimeout(this.configuration.getScriptTimeout().longValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void takeHtmlDump() {
        this.takeHtmlDump(new Date().getTime() + ".html");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takeHtmlDump(String fileName) {
        File destFile = null;
        try {
            destFile = this.configuration.getHtmlDumpPath() == null ? new File(fileName) : Paths.get(this.configuration.getHtmlDumpPath(), fileName).toFile();
            Class<FluentDriver> clazz = FluentDriver.class;
            synchronized (FluentDriver.class) {
                String html = ((FluentWebElement)this.$("html", new SearchFilter[0]).first()).html();
                // ** MonitorExit[var4_3] (shouldn't be in output)
                FileUtils.write((File)destFile, (CharSequence)html, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            if (destFile == null) {
                destFile = new File(fileName);
            }
            try (PrintWriter printWriter = new PrintWriter(destFile, "UTF-8");){
                printWriter.write("Can't dump HTML");
                printWriter.println();
                e.printStackTrace(printWriter);
            }
            catch (IOException e1) {
                throw new RuntimeException("error when dumping HTML", e);
            }
        }
    }

    @Override
    public boolean canTakeScreenShot() {
        return this.getDriver() instanceof TakesScreenshot;
    }

    @Override
    public void takeScreenshot() {
        this.takeScreenshot(new Date().getTime() + ".png");
    }

    @Override
    public void takeScreenshot(String fileName) {
        if (!this.canTakeScreenShot()) {
            throw new WebDriverException("Current browser doesn't allow taking screenshot.");
        }
        byte[] screenshot = this.prepareScreenshot();
        this.persistScreenshot(fileName, screenshot);
    }

    private void persistScreenshot(String fileName, byte[] screenshot) {
        try {
            File destFile = this.configuration.getScreenshotPath() == null ? new File(fileName) : Paths.get(this.configuration.getScreenshotPath(), fileName).toFile();
            FileUtils.writeByteArrayToFile((File)destFile, (byte[])screenshot);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when taking the screenshot", e);
        }
    }

    private byte[] prepareScreenshot() {
        byte[] screenshot;
        try {
            screenshot = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
        }
        catch (UnhandledAlertException uae) {
            ImageUtils imageUtils = new ImageUtils(this.getDriver());
            screenshot = imageUtils.handleAlertAndTakeScreenshot();
        }
        return screenshot;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    private Search getSearch() {
        return this.search;
    }

    @Override
    public EventsRegistry events() {
        if (this.events == null) {
            throw new IllegalStateException("An EventFiringWebDriver instance is required to use events. You should set 'eventsEnabled' configuration property to 'true' or override newWebDriver() to build an EventFiringWebDriver.");
        }
        return this.events;
    }

    @Override
    public MouseActions mouse() {
        return this.mouseActions;
    }

    @Override
    public KeyboardActions keyboard() {
        return this.keyboardActions;
    }

    @Override
    public WindowAction window() {
        return this.windowAction;
    }

    @Override
    public FluentWait await() {
        Long pollingEvery;
        FluentWait fluentWait = new FluentWait(this);
        Long atMost = this.configuration.getAwaitAtMost();
        if (atMost != null) {
            fluentWait.atMost(atMost);
        }
        if ((pollingEvery = this.configuration.getAwaitPollingEvery()) != null) {
            fluentWait.pollingEvery(pollingEvery);
        }
        return fluentWait;
    }

    @Override
    public Set<Cookie> getCookies() {
        return this.getDriver().manage().getCookies();
    }

    @Override
    public Cookie getCookie(String name) {
        return this.getDriver().manage().getCookieNamed(name);
    }

    private String buildUrl(String url) {
        String currentUrl = this.getDriver().getCurrentUrl();
        String baseUrl = UrlUtils.sanitizeBaseUrl(this.getBaseUrl(), currentUrl);
        return UrlUtils.concat(baseUrl, url);
    }

    @Override
    public String url() {
        String baseUrl = this.buildUrl(null);
        String currentUrl = this.getDriver().getCurrentUrl();
        if (currentUrl != null && baseUrl != null && currentUrl.startsWith(baseUrl)) {
            currentUrl = currentUrl.substring(baseUrl.length());
        }
        return currentUrl;
    }

    @Override
    public String pageSource() {
        return this.getDriver().getPageSource();
    }

    @Override
    public <P extends FluentPage> P goTo(P page) {
        if (page == null) {
            throw new IllegalArgumentException("Page is mandatory");
        }
        page.go();
        return page;
    }

    @Override
    public void goTo(String url) {
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        this.getDriver().get(this.buildUrl(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goToInNewTab(String url) {
        String newTab;
        if (url == null) {
            throw new IllegalArgumentException("Url is mandatory");
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Set initialTabs = this.getDriver().getWindowHandles();
            this.executeScript("window.open('" + this.buildUrl(url) + "', '_blank');", new Object[0]);
            Set tabs = this.getDriver().getWindowHandles();
            tabs.removeAll(initialTabs);
            newTab = (String)tabs.iterator().next();
        }
        this.getDriver().switchTo().window(newTab);
    }

    @Override
    public Capabilities capabilities() {
        Capabilities capabilities;
        WebDriver currentDriver = this.getDriver();
        Capabilities capabilities2 = capabilities = currentDriver instanceof HasCapabilities ? ((HasCapabilities)currentDriver).getCapabilities() : null;
        while (currentDriver instanceof WrapsDriver && capabilities == null) {
            capabilities = (currentDriver = ((WrapsDriver)currentDriver).getWrappedDriver()) instanceof HasCapabilities ? ((HasCapabilities)currentDriver).getCapabilities() : null;
        }
        return capabilities;
    }

    @Override
    public FluentJavascript executeScript(String script, Object ... args) {
        return new FluentJavascript((JavascriptExecutor)this.getDriver(), false, script, args);
    }

    @Override
    public FluentJavascript executeAsyncScript(String script, Object ... args) {
        return new FluentJavascript((JavascriptExecutor)this.getDriver(), true, script, args);
    }

    @Override
    public FluentList<FluentWebElement> find(String selector, SearchFilter ... filters) {
        return this.getSearch().find(selector, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(By locator, SearchFilter ... filters) {
        return this.getSearch().find(locator, filters);
    }

    @Override
    public FluentList<FluentWebElement> find(SearchFilter ... filters) {
        return this.getSearch().find(filters);
    }

    @Override
    public FluentList<FluentWebElement> find(List<WebElement> rawElements) {
        return this.getSearch().find(rawElements);
    }

    @Override
    public FluentList<FluentWebElement> $(List<WebElement> rawElements) {
        return this.getSearch().$(rawElements);
    }

    @Override
    public FluentWebElement el(WebElement rawElement) {
        return this.getSearch().el(rawElement);
    }

    @Override
    public void switchTo(FluentList<? extends FluentWebElement> elements) {
        this.switchTo(elements.first());
    }

    @Override
    public void switchTo(FluentWebElement element) {
        if (null == element || !"iframe".equals(element.tagName())) {
            this.getDriver().switchTo().defaultContent();
        } else {
            WebElement target = element.getElement();
            while (target instanceof WrapsElement && target != ((WrapsElement)target).getWrappedElement()) {
                target = ((WrapsElement)target).getWrappedElement();
            }
            this.getDriver().switchTo().frame(target);
        }
    }

    @Override
    public void switchTo() {
        this.switchTo((FluentWebElement)null);
    }

    @Override
    public void switchToDefault() {
        this.switchTo((FluentWebElement)null);
    }

    @Override
    public Alert alert() {
        return new AlertImpl(this.getDriver());
    }

    public void quit() {
        if (this.getDriver() != null) {
            this.getDriver().quit();
        }
        this.releaseFluent();
    }

    public void releaseFluent() {
        this.fluentInjector.release();
        if (this.componentsEventsRegistry != null) {
            this.componentsEventsRegistry.close();
        }
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass) {
        return this.getComponentsManager().newComponentList(listClass, componentClass);
    }

    @Override
    public <T> ComponentList asComponentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getComponentsManager().asComponentList(componentClass, elements);
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, T ... componentsList) {
        return this.getComponentsManager().newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getComponentsManager().asFluentList(componentClass, elements);
    }

    @Override
    public boolean isComponentClass(Class<?> componentClass) {
        return this.getComponentsManager().isComponentClass(componentClass);
    }

    @Override
    public <T> ComponentList<T> asComponentList(Class<T> componentClass, List<WebElement> elements) {
        return this.getComponentsManager().asComponentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, WebElement ... elements) {
        return this.getComponentsManager().asFluentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass) {
        return this.getComponentsManager().newFluentList(componentClass);
    }

    @Override
    public FluentWebElement newFluent(WebElement element) {
        return this.getComponentsManager().newFluent(element);
    }

    @Override
    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        return this.getComponentsManager().isComponentListClass(componentListClass);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(WebElement ... elements) {
        return this.getComponentsManager().asFluentList(elements);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(Iterable<WebElement> elements) {
        return this.getComponentsManager().asFluentList(elements);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, WebElement ... elements) {
        return this.getComponentsManager().asComponentList(listClass, componentClass, elements);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, Iterable<WebElement> elements) {
        return this.getComponentsManager().asComponentList(listClass, componentClass, elements);
    }

    @Override
    public FluentList<FluentWebElement> asFluentList(List<WebElement> elements) {
        return this.getComponentsManager().asFluentList(elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> asFluentList(Class<T> componentClass, List<WebElement> elements) {
        return this.getComponentsManager().asFluentList(componentClass, elements);
    }

    @Override
    public <T> ComponentList<T> asComponentList(Class<T> componentClass, WebElement ... elements) {
        return this.getComponentsManager().asComponentList(componentClass, elements);
    }

    @Override
    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        return this.getComponentsManager().newComponent(componentClass, element);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass, T ... componentsList) {
        return this.getComponentsManager().newComponentList(componentClass, componentsList);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass, List<T> componentsList) {
        return this.getComponentsManager().newComponentList(componentClass, componentsList);
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        return this.getComponentsManager().newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public FluentList<FluentWebElement> newFluentList() {
        return this.getComponentsManager().newFluentList();
    }

    @Override
    public FluentList<FluentWebElement> newFluentList(List<FluentWebElement> elements) {
        return this.getComponentsManager().newFluentList(elements);
    }

    @Override
    public <T> ComponentList<T> newComponentList(Class<T> componentClass) {
        return this.getComponentsManager().newComponentList(componentClass);
    }

    @Override
    public FluentList<FluentWebElement> newFluentList(FluentWebElement ... elements) {
        return this.getComponentsManager().newFluentList(elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, List<T> elements) {
        return this.getComponentsManager().newFluentList(componentClass, elements);
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> newFluentList(Class<T> componentClass, T ... elements) {
        return this.getComponentsManager().newFluentList(componentClass, (FluentWebElement[])elements);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, List<WebElement> elements) {
        return this.getComponentsManager().asComponentList(listClass, componentClass, elements);
    }

    @Override
    public ContainerContext inject(Object container) {
        return this.getFluentInjector().inject(container);
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        return this.getFluentInjector().newInstance(cls);
    }

    @Override
    public ContainerContext injectComponent(Object componentContainer, Object parentContainer, SearchContext searchContext) {
        return this.getFluentInjector().injectComponent(componentContainer, parentContainer, searchContext);
    }

    @Override
    public CssSupport css() {
        return this.getCssControl().css();
    }
}

