/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.performance;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.fluentlenium.core.performance.PerformanceTimingEvent;
import org.fluentlenium.core.performance.PerformanceTimingMetrics;

public class DefaultPerformanceTimingMetrics
implements PerformanceTimingMetrics<DefaultPerformanceTimingMetrics> {
    private final Map<String, Object> timingMetrics = new HashMap<String, Object>();
    private final TimeUnit sourceTimeUnit;

    public DefaultPerformanceTimingMetrics(Map<String, Object> timingMetrics) {
        this.timingMetrics.putAll(this.calculateTimesSinceNavigationStart(Objects.requireNonNull(timingMetrics)));
        this.sourceTimeUnit = TimeUnit.MILLISECONDS;
    }

    protected DefaultPerformanceTimingMetrics(Map<String, Object> timingMetrics, TimeUnit timeUnit) {
        this.timingMetrics.putAll(Objects.requireNonNull(timingMetrics));
        this.sourceTimeUnit = timeUnit;
    }

    @Override
    public DefaultPerformanceTimingMetrics in(TimeUnit targetTimeUnit) {
        Map<String, Object> metrics = this.convertEntriesBy(this.timingMetrics, entryValue -> targetTimeUnit.convert((Long)entryValue, this.sourceTimeUnit));
        metrics.putIfAbsent(PerformanceTimingEvent.SECURE_CONNECTION_START.getEvent(), this.timingMetrics.get(PerformanceTimingEvent.SECURE_CONNECTION_START.getEvent()));
        return new DefaultPerformanceTimingMetrics(metrics, targetTimeUnit);
    }

    public Map<String, Object> getAllMetrics() {
        return ImmutableMap.copyOf(this.timingMetrics);
    }

    public TimeUnit getSourceTimeUnit() {
        return this.sourceTimeUnit;
    }

    @Override
    public long getUnloadEventStart() {
        return this.getEvent(PerformanceTimingEvent.UNLOAD_EVENT_START);
    }

    @Override
    public long getUnloadEventEnd() {
        return this.getEvent(PerformanceTimingEvent.UNLOAD_EVENT_END);
    }

    @Override
    public long getRedirectStart() {
        return this.getEvent(PerformanceTimingEvent.REDIRECT_START);
    }

    @Override
    public long getRedirectEnd() {
        return this.getEvent(PerformanceTimingEvent.REDIRECT_END);
    }

    @Override
    public long getNavigationStart() {
        return this.getEvent(PerformanceTimingEvent.NAVIGATION_START);
    }

    @Override
    public long getFetchStart() {
        return this.getEvent(PerformanceTimingEvent.FETCH_START);
    }

    @Override
    public long getDomainLookupStart() {
        return this.getEvent(PerformanceTimingEvent.DOMAIN_LOOKUP_START);
    }

    @Override
    public long getDomainLookupEnd() {
        return this.getEvent(PerformanceTimingEvent.DOMAIN_LOOKUP_END);
    }

    @Override
    public long getConnectStart() {
        return this.getEvent(PerformanceTimingEvent.CONNECT_START);
    }

    @Override
    public long getConnectEnd() {
        return this.getEvent(PerformanceTimingEvent.CONNECT_END);
    }

    @Override
    public Object getSecureConnectionStart() {
        return this.timingMetrics.get(PerformanceTimingEvent.SECURE_CONNECTION_START.getEvent());
    }

    @Override
    public long getRequestStart() {
        return this.getEvent(PerformanceTimingEvent.REQUEST_START);
    }

    @Override
    public long getResponseStart() {
        return this.getEvent(PerformanceTimingEvent.RESPONSE_START);
    }

    @Override
    public long getResponseEnd() {
        return this.getEvent(PerformanceTimingEvent.RESPONSE_END);
    }

    @Override
    public long getDomLoading() {
        return this.getEvent(PerformanceTimingEvent.DOM_LOADING);
    }

    @Override
    public long getDomInteractive() {
        return this.getEvent(PerformanceTimingEvent.DOM_INTERACTIVE);
    }

    @Override
    public long getDomContentLoadedEventStart() {
        return this.getEvent(PerformanceTimingEvent.DOM_CONTENT_LOADED_EVENT_START);
    }

    @Override
    public long getDomContentLoadedEventEnd() {
        return this.getEvent(PerformanceTimingEvent.DOM_CONTENT_LOADED_EVENT_END);
    }

    @Override
    public long getDomComplete() {
        return this.getEvent(PerformanceTimingEvent.DOM_COMPLETE);
    }

    @Override
    public long getLoadEventStart() {
        return this.getEvent(PerformanceTimingEvent.LOAD_EVENT_START);
    }

    @Override
    public long getLoadEventEnd() {
        return this.getEvent(PerformanceTimingEvent.LOAD_EVENT_END);
    }

    private Map<String, Object> calculateTimesSinceNavigationStart(Map<String, Object> timingMetrics) {
        long navigationStartEpoch = (Long)timingMetrics.get(PerformanceTimingEvent.NAVIGATION_START.getEvent());
        Map<String, Object> metrics = this.convertEntriesBy(timingMetrics, entryValue -> (Long)entryValue - navigationStartEpoch);
        metrics.putIfAbsent(PerformanceTimingEvent.SECURE_CONNECTION_START.getEvent(), timingMetrics.get(PerformanceTimingEvent.SECURE_CONNECTION_START.getEvent()));
        return metrics;
    }

    private Map<String, Object> convertEntriesBy(Map<String, Object> timingMetrics, Function<Object, Long> valueMapper) {
        return timingMetrics.entrySet().stream().filter(entry -> this.canBeCastToLong(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> (Long)valueMapper.apply(entry.getValue())));
    }

    private long getEvent(PerformanceTimingEvent event) {
        return (Long)this.timingMetrics.get(event.getEvent());
    }

    private boolean canBeCastToLong(Object value) {
        try {
            long converted = (Long)value;
            return true;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }
}

