/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.performance;

import org.fluentlenium.core.performance.PerformanceTiming;
import org.fluentlenium.core.performance.PerformanceTimingEvent;
import org.fluentlenium.core.performance.PerformanceTimingMetrics;
import org.fluentlenium.core.performance.PerformanceTimingMetricsFactory;
import org.fluentlenium.utils.Preconditions;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class DefaultPerformanceTiming
implements PerformanceTiming {
    private static final String PERFORMANCE_TIMING_SCRIPT = "return window.performance.timing;";
    private static final String PERFORMANCE_TIMING_EVENTS_SCRIPT = "return window.performance.timing.%s;";
    private final WebDriver driver;
    private final PerformanceTimingMetricsFactory metricsFactory = new PerformanceTimingMetricsFactory();

    public DefaultPerformanceTiming(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public long getEventValue(PerformanceTimingEvent event) {
        Preconditions.checkArgument(event, "The event should not be null.");
        return this.timePassedUntil(this.execute(this.scriptFor(event)));
    }

    @Override
    public Object secureConnectionStart() {
        Object secureConnectionStart = this.execute(this.scriptFor(PerformanceTimingEvent.SECURE_CONNECTION_START));
        if (secureConnectionStart instanceof Long) {
            secureConnectionStart = this.timePassedUntil(secureConnectionStart);
        }
        return secureConnectionStart;
    }

    @Override
    public PerformanceTimingMetrics getMetrics() {
        return this.metricsFactory.createFor(this.execute(PERFORMANCE_TIMING_SCRIPT));
    }

    private long timePassedUntil(Object eventTime) {
        return (Long)eventTime - this.getNavigationStart();
    }

    private Object execute(String command) {
        return ((JavascriptExecutor)this.driver).executeScript(command, new Object[0]);
    }

    private String scriptFor(PerformanceTimingEvent event) {
        return String.format(PERFORMANCE_TIMING_EVENTS_SCRIPT, new Object[]{event});
    }

    private long getNavigationStart() {
        return (Long)this.execute(this.scriptFor(PerformanceTimingEvent.NAVIGATION_START));
    }
}

