/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.action.Fill;
import org.fluentlenium.core.action.FillSelect;
import org.fluentlenium.core.action.FluentJavascriptActions;
import org.fluentlenium.core.action.FluentJavascriptActionsImpl;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.conditions.AtLeastOneElementConditions;
import org.fluentlenium.core.conditions.EachElementConditions;
import org.fluentlenium.core.conditions.FluentListConditions;
import org.fluentlenium.core.conditions.wait.WaitConditionProxy;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookControl;
import org.fluentlenium.core.hook.HookControlImpl;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.label.FluentLabel;
import org.fluentlenium.core.label.FluentLabelImpl;
import org.fluentlenium.core.proxy.LocatorHandler;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.search.SearchFilter;
import org.fluentlenium.core.wait.FluentWaitElementList;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class FluentListImpl<E extends FluentWebElement>
extends ComponentList<E>
implements FluentList<E> {
    private static final Duration DEFAULT_WAIT_AND_CLICK_DURATION = Duration.ofSeconds(5L);
    private final FluentLabel<FluentList<E>> label;
    private final HookControl<FluentList<E>> hookControl;
    private final FluentJavascriptActions<FluentList<E>> javascriptActions;

    public FluentListImpl(Class<E> componentClass, List<E> list, FluentControl control, ComponentInstantiator instantiator) {
        super(componentClass, list, control, instantiator);
        this.hookControl = new HookControlImpl<FluentList>(this, this.proxy, control, instantiator, () -> {
            LocatorHandler locatorHandler = LocatorProxies.getLocatorHandler(this.proxy);
            ElementLocator locator = locatorHandler.getLocator();
            List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
            return (FluentList)instantiator.asComponentList(this.getClass(), componentClass, webElementList);
        });
        this.label = new FluentLabelImpl<FluentListImpl>(this, list::toString);
        this.javascriptActions = new FluentJavascriptActionsImpl<FluentListImpl>(this, this.control, new Supplier<FluentWebElement>(){

            @Override
            public FluentWebElement get() {
                return FluentListImpl.this.first();
            }

            public String toString() {
                return String.valueOf(FluentListImpl.this.first());
            }
        });
    }

    private FluentLabelImpl<FluentList<E>> getLabelImpl() {
        return (FluentLabelImpl)this.label;
    }

    private HookControlImpl<FluentList<E>> getHookControlImpl() {
        return (HookControlImpl)this.hookControl;
    }

    @Override
    public FluentWaitElementList await() {
        return new FluentWaitElementList(this.control.await(), this);
    }

    @Override
    public E first() {
        if (!LocatorProxies.loaded(this.proxy)) {
            FluentWebElement component = (FluentWebElement)this.instantiator.newComponent(this.componentClass, LocatorProxies.first(this.proxy));
            this.configureComponentWithLabel(component);
            this.configureComponentWithHooks(component);
            return (E)component;
        }
        this.validateListIsNotEmpty();
        return (E)this.get(0);
    }

    @Override
    public E single() {
        if (this.size() > 1) {
            throw new AssertionError((Object)String.format("%s list should contain one element only but there are [ %s ] elements instead", LocatorProxies.getMessageContext(this.proxy), this.size()));
        }
        return this.first();
    }

    @Override
    public E last() {
        if (!LocatorProxies.loaded(this.proxy)) {
            FluentWebElement component = (FluentWebElement)this.instantiator.newComponent(this.componentClass, LocatorProxies.last(this.proxy));
            this.configureComponentWithLabel(component);
            this.configureComponentWithHooks(component);
            return (E)component;
        }
        this.validateListIsNotEmpty();
        return (E)this.get(this.size() - 1);
    }

    @Override
    public E get(int index) {
        return this.index(index);
    }

    @Override
    public E index(int index) {
        if (!LocatorProxies.loaded(this.proxy) && !this.componentClass.equals(FluentWebElement.class)) {
            FluentWebElement component = (FluentWebElement)this.instantiator.newComponent(this.componentClass, LocatorProxies.index(this.proxy, index));
            this.configureComponentWithLabel(component);
            this.configureComponentWithHooks(component);
            if (component instanceof FluentWebElement) {
                component.setHookRestoreStack(this.getHookControlImpl().getHookRestoreStack());
            }
            return (E)((FluentWebElement)component.reset().as(this.componentClass));
        }
        if (this.size() <= index) {
            throw LocatorProxies.noSuchElement(this.proxy);
        }
        return (E)((FluentWebElement)super.get(index));
    }

    @Override
    public int count() {
        LocatorHandler locatorHandler;
        if (this.proxy != null && (locatorHandler = LocatorProxies.getLocatorHandler(this.proxy)) != null) {
            return locatorHandler.getLocator().findElements().size();
        }
        return super.size();
    }

    @Override
    public boolean present() {
        if (LocatorProxies.getLocatorHandler(this.proxy) != null) {
            return LocatorProxies.present(this);
        }
        return this.size() > 0;
    }

    @Override
    public FluentList<E> now() {
        LocatorProxies.now(this);
        this.validateListIsNotEmpty();
        return this;
    }

    @Override
    public FluentList<E> now(boolean force) {
        if (force) {
            this.reset();
        }
        return this.now();
    }

    @Override
    public FluentList<E> reset() {
        LocatorProxies.reset(this);
        return this;
    }

    @Override
    public boolean loaded() {
        return LocatorProxies.loaded(this);
    }

    @Override
    public FluentList<E> click() {
        return this.doClick(FluentWebElement::click, "click");
    }

    @Override
    public FluentList<E> doubleClick() {
        return this.doClick(FluentWebElement::doubleClick, "double click");
    }

    @Override
    public FluentList<E> contextClick() {
        return this.doClick(FluentWebElement::contextClick, "context click");
    }

    @Override
    public FluentList<E> waitAndClick() {
        return this.waitAndClick(DEFAULT_WAIT_AND_CLICK_DURATION);
    }

    @Override
    public FluentList<E> waitAndClick(Duration duration) {
        this.validateListIsNotEmpty();
        this.await().atMost(duration).until(this).clickable();
        this.scrollToCenter();
        this.click();
        return this;
    }

    @Override
    public FluentList<E> write(String ... with) {
        this.validateListIsNotEmpty();
        boolean atLeastOne = false;
        if (with.length > 0) {
            int id = 0;
            for (FluentWebElement fluentWebElement : this) {
                if (!fluentWebElement.displayed()) continue;
                String value = with.length > id ? with[id++] : with[with.length - 1];
                if (!fluentWebElement.enabled()) continue;
                atLeastOne = true;
                fluentWebElement.write(value);
            }
            if (!atLeastOne) {
                throw new NoSuchElementException(LocatorProxies.getMessageContext(this.proxy) + " has no element displayed and enabled. At least one element should be displayed and enabled to define values.");
            }
        }
        return this;
    }

    @Override
    public FluentList<E> clearAll() {
        return this.clearAllInputs(FluentWebElement::clear, "clear values");
    }

    @Override
    public FluentList<E> clearAllReactInputs() {
        return this.clearAllInputs(FluentWebElement::clearReactInput, "clear values by using backspace");
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public FluentListConditions each() {
        return new EachElementConditions(this);
    }

    @Override
    public FluentListConditions one() {
        return new AtLeastOneElementConditions(this);
    }

    @Override
    public FluentListConditions awaitUntilEach() {
        return WaitConditionProxy.each(this.control.await(), this.toString(), new SupplierOfInstance<FluentListImpl>(this));
    }

    @Override
    public FluentListConditions awaitUntilOne() {
        return WaitConditionProxy.one(this.control.await(), this.toString(), new SupplierOfInstance<FluentListImpl>(this));
    }

    @Override
    public FluentList<E> submit() {
        return this.perform(FluentWebElement::submit, FluentWebElement::enabled, " has no element enabled. At least one element should be enabled to perform a submit.");
    }

    @Override
    public FluentList<E> find(List<WebElement> rawElements) {
        return this.control.find(rawElements);
    }

    @Override
    public FluentList<E> $(List<WebElement> rawElements) {
        return this.control.$(rawElements);
    }

    @Override
    public E el(WebElement rawElement) {
        return this.control.el(rawElement);
    }

    @Override
    public FluentList<E> find(String selector, SearchFilter ... filters) {
        return this.findBy(e -> e.find(selector, filters));
    }

    @Override
    public FluentList<E> find(By locator, SearchFilter ... filters) {
        return this.findBy(e -> e.find(locator, filters));
    }

    @Override
    public FluentList<E> find(SearchFilter ... filters) {
        return this.findBy(e -> e.find(filters));
    }

    @Override
    public Fill fill() {
        return new Fill<FluentListImpl>(this);
    }

    @Override
    public FillSelect fillSelect() {
        return new FillSelect<FluentListImpl>(this);
    }

    @Override
    public FluentList<E> frame() {
        this.control.window().switchTo().frame((FluentWebElement)this.first());
        return this;
    }

    @Override
    public Optional<FluentList<E>> optional() {
        if (this.present()) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    @Override
    public <T extends FluentWebElement> FluentList<T> as(Class<T> componentClass) {
        return (FluentList)this.instantiator.newComponentList(this.getClass(), componentClass, this.stream().map(e -> (FluentWebElement)e.as(componentClass)).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    public String toString() {
        return this.label.toString();
    }

    private void configureComponentWithHooks(E component) {
        if (component instanceof HookControl) {
            for (HookDefinition<?> definition : this.getHookControlImpl().getHookDefinitions()) {
                ((FluentWebElement)component).withHook(definition.getHookClass(), definition.getOptions());
            }
        }
    }

    private void configureComponentWithLabel(E component) {
        if (component instanceof FluentLabel) {
            ((FluentWebElement)component).withLabel(this.getLabelImpl().getLabel());
            ((FluentWebElement)component).withLabelHint(this.getLabelImpl().getLabelHints());
        }
    }

    private FluentList<E> doClick(Consumer<E> clickAction, String clickType) {
        return this.perform(clickAction, fluentWebElement -> fluentWebElement.conditions().clickable(), " has no element clickable. At least one element should be clickable to perform a " + clickType + ".");
    }

    private FluentList<E> clearAllInputs(Consumer<E> action, String actionMessage) {
        return this.perform(action, FluentWebElement::enabled, " has no element enabled. At least one element should be enabled to " + actionMessage + ".");
    }

    private FluentList<E> perform(Consumer<E> action, Predicate<E> condition, String message) {
        this.validateListIsNotEmpty();
        boolean atLeastOne = false;
        for (FluentWebElement fluentWebElement : this) {
            if (!condition.test(fluentWebElement)) continue;
            atLeastOne = true;
            action.accept(fluentWebElement);
        }
        if (!atLeastOne) {
            throw new NoSuchElementException(LocatorProxies.getMessageContext(this.proxy) + message);
        }
        return this;
    }

    private void validateListIsNotEmpty() {
        if (this.size() == 0) {
            throw LocatorProxies.noSuchElement(this.proxy);
        }
    }

    private FluentList<E> findBy(Function<FluentWebElement, Collection<E>> filteredElementsFinder) {
        ArrayList<E> finds = new ArrayList<E>();
        for (FluentWebElement e : this) {
            finds.addAll(filteredElementsFinder.apply(e));
        }
        return (FluentList)this.instantiator.newComponentList(this.getClass(), this.componentClass, finds);
    }

    @Override
    public FluentList<E> withLabel(String label) {
        return this.label.withLabel(label);
    }

    @Override
    public FluentList<E> withLabelHint(String ... labelHint) {
        return this.label.withLabelHint(labelHint);
    }

    @Override
    public FluentList<E> noHookInstance() {
        return this.hookControl.noHookInstance();
    }

    @Override
    public FluentList<E> noHook() {
        return this.hookControl.noHook();
    }

    @Override
    public <O, H extends FluentHook<O>> FluentList<E> withHook(Class<H> hook) {
        return this.hookControl.withHook(hook);
    }

    @Override
    public <R> R noHook(Class<? extends FluentHook> hook, Function<FluentList<E>, R> function) {
        return this.hookControl.noHook(hook, function);
    }

    @Override
    public FluentList<E> restoreHooks() {
        return this.hookControl.restoreHooks();
    }

    @Override
    public <O, H extends FluentHook<O>> FluentList<E> withHook(Class<H> hook, O options) {
        return this.hookControl.withHook(hook, options);
    }

    @Override
    public FluentList<E> noHook(Class<? extends FluentHook> ... hooks) {
        return this.hookControl.noHook(hooks);
    }

    @Override
    public FluentList<E> noHookInstance(Class<? extends FluentHook> ... hooks) {
        return this.hookControl.noHookInstance(hooks);
    }

    @Override
    public <R> R noHook(Function<FluentList<E>, R> function) {
        return this.hookControl.noHook(function);
    }

    public FluentList<E> scrollToCenter() {
        return this.javascriptActions.scrollToCenter();
    }

    public FluentList<E> scrollIntoView(boolean alignWithTop) {
        return this.javascriptActions.scrollIntoView(alignWithTop);
    }

    public FluentList<E> modifyAttribute(String attributeName, String attributeValue) {
        return this.javascriptActions.modifyAttribute(attributeName, attributeValue);
    }

    public FluentList<E> scrollIntoView() {
        return this.javascriptActions.scrollIntoView();
    }
}

