/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Mouse;

public class MouseElementActions {
    private final WebDriver driver;
    private final WebElement element;

    public MouseElementActions(WebDriver driver, WebElement element) {
        this.driver = driver;
        this.element = element;
    }

    public MouseElementActions(WebDriver driver, FluentWebElement fluentWebElement) {
        this(driver, fluentWebElement.getElement());
    }

    private Actions actions() {
        return new Actions(this.driver);
    }

    @Deprecated
    public Mouse basic() {
        return ((HasInputDevices)this.driver).getMouse();
    }

    public MouseElementActions clickAndHold() {
        this.loadElementAndPerform(this.actions().clickAndHold(this.element));
        return this;
    }

    public MouseElementActions release() {
        this.loadElementAndPerform(this.actions().release(this.element));
        return this;
    }

    public MouseElementActions click() {
        this.loadElementAndPerform(this.actions().click(this.element));
        return this;
    }

    public MouseElementActions doubleClick() {
        this.loadElementAndPerform(this.actions().doubleClick(this.element));
        return this;
    }

    public MouseElementActions moveToElement() {
        this.loadElementAndPerform(this.actions().moveToElement(this.element));
        return this;
    }

    public MouseElementActions moveToElement(WebElement target) {
        this.loadElementAndPerform(this.actions().moveToElement(target));
        return this;
    }

    public MouseElementActions moveToElement(int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().moveToElement(this.element, xOffset, yOffset));
        return this;
    }

    public MouseElementActions moveToElement(WebElement target, int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().moveToElement(target, xOffset, yOffset));
        return this;
    }

    public MouseElementActions contextClick() {
        this.loadElementAndPerform(this.actions().contextClick(this.element));
        return this;
    }

    public MouseElementActions dragAndDropFrom(WebElement source) {
        this.loadElementAndPerform(this.actions().dragAndDrop(source, this.element));
        return this;
    }

    public MouseElementActions dragAndDropTo(WebElement target) {
        this.loadElementAndPerform(this.actions().dragAndDrop(this.element, target));
        return this;
    }

    public MouseElementActions dragAndDropBy(int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().dragAndDropBy(this.element, xOffset, yOffset));
        return this;
    }

    public MouseElementActions dragAndDropByWithTargetOffset(WebElement target, int xOffset, int yOffset) {
        this.loadElementAndPerform(this.actions().clickAndHold(this.element).moveToElement(target, xOffset, yOffset).release());
        return this;
    }

    private void loadElementAndPerform(Actions action) {
        this.loadElement();
        action.perform();
    }

    private void loadElement() {
        LocatorProxies.now(this.element);
    }
}

