/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.fluentlenium.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentDriverHtmlDumper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentDriverHtmlDumper.class);
    private final Configuration configuration;

    public FluentDriverHtmlDumper(Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public void takeHtmlDump(String fileName, Supplier<String> htmlSupplier) {
        File destFile = null;
        try {
            destFile = this.getDestinationFile(fileName);
            FileUtils.write((File)destFile, (CharSequence)htmlSupplier.get(), (String)"UTF-8");
            LOGGER.info("Created HTML dump at: " + destFile.getAbsolutePath());
        }
        catch (IOException e) {
            try (PrintWriter printWriter = new PrintWriter(destFile, "UTF-8");){
                printWriter.write("Can't dump HTML");
                printWriter.println();
                e.printStackTrace(printWriter);
            }
            catch (IOException ioe) {
                throw new RuntimeException("Error when dumping HTML", e);
            }
        }
    }

    private File getDestinationFile(String fileName) {
        File destFile = this.configuration.getHtmlDumpPath() == null ? new File(fileName) : Paths.get(this.configuration.getHtmlDumpPath(), fileName).toFile();
        return destFile;
    }
}

