/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.fluentlenium.configuration.AbstractFactoryRegistryImpl;
import org.fluentlenium.configuration.CapabilitiesFactory;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.fluentlenium.configuration.DefaultFactory;
import org.fluentlenium.configuration.IndexIgnore;
import org.fluentlenium.configuration.MethodInvocationReflectionFactory;
import org.fluentlenium.configuration.ReflectiveCapabilitiesFactory;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilitiesRegistryImpl
extends AbstractFactoryRegistryImpl<CapabilitiesFactory, ReflectiveCapabilitiesFactory> {
    public CapabilitiesRegistryImpl() {
        super(CapabilitiesFactory.class, ReflectiveCapabilitiesFactory.class);
        this.registerDesiredCapabilities();
    }

    private void registerDesiredCapabilities() {
        Method[] declaredMethods;
        for (Method method : declaredMethods = DesiredCapabilities.class.getDeclaredMethods()) {
            if (!Modifier.isStatic(method.getModifiers()) || !Capabilities.class.isAssignableFrom(method.getReturnType())) continue;
            DesiredCapabilitiesFactory factory = new DesiredCapabilitiesFactory(method);
            this.register(factory);
        }
    }

    @Override
    protected ReflectiveCapabilitiesFactory newReflectiveInstance(String name) {
        return new ReflectiveCapabilitiesFactory(name, name, new Object[0]);
    }

    @Override
    protected CapabilitiesFactory getDefault(List<CapabilitiesFactory> filteredFactories) {
        ArrayList<CapabilitiesFactory> defaultFactories = new ArrayList<CapabilitiesFactory>();
        block0: for (CapabilitiesFactory factory : filteredFactories) {
            if (factory.getClass().isAnnotationPresent(IndexIgnore.class)) continue;
            for (Class<?> iface : factory.getClass().getInterfaces()) {
                if (iface.isAnnotationPresent(IndexIgnore.class)) continue block0;
            }
            defaultFactories.add(factory);
        }
        if (defaultFactories.isEmpty()) {
            return null;
        }
        return (CapabilitiesFactory)defaultFactories.get(0);
    }

    @Override
    protected void handleNoFactoryAvailable(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Capabilities newCapabilities(String name, ConfigurationProperties configuration) {
        CapabilitiesRegistryImpl capabilitiesRegistryImpl = this;
        synchronized (capabilitiesRegistryImpl) {
            return ((CapabilitiesFactory)this.get(name)).newCapabilities(configuration);
        }
    }

    @DefaultFactory
    public static class DesiredCapabilitiesFactory
    extends MethodInvocationReflectionFactory {
        public DesiredCapabilitiesFactory(Method method) {
            super(method, null, new Object[0]);
        }
    }
}

