/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.message.MessageProxy;
import org.fluentlenium.core.wait.FluentWait;

public class BaseWaitConditions {
    protected Function<String, String> messageCustomizer() {
        return Function.identity();
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, String message) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            message = this.messageCustomizer().apply(message);
            wait.withMessage(message).untilPredicate(present);
        }
    }

    protected void until(FluentWait wait, Predicate<FluentControl> present, final Supplier<String> messageSupplier) {
        if (wait.hasMessageDefined()) {
            wait.untilPredicate(present);
        } else {
            Supplier<String> customMessageSupplier = new Supplier<String>(){

                @Override
                public String get() {
                    return BaseWaitConditions.this.messageCustomizer().apply((String)messageSupplier.get());
                }
            };
            ((FluentWait)wait.withMessage((Supplier)customMessageSupplier)).untilPredicate(present);
        }
    }

    protected <T extends Conditions<?>> void until(FluentWait wait, T condition, T messageBuilder, Function<T, Boolean> conditionFunction) {
        Predicate<FluentControl> predicate = input -> (Boolean)conditionFunction.apply(condition);
        Supplier<String> messageSupplier = () -> {
            conditionFunction.apply(messageBuilder);
            return MessageProxy.message(messageBuilder);
        };
        this.until(wait, predicate, messageSupplier);
    }
}

