/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.proxy;

import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.utils.SupplierOfInstance;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ElementListSupplierLocator
implements ElementLocator {
    private final Supplier<List<WebElement>> elementsSupplier;

    public ElementListSupplierLocator(List<WebElement> elements) {
        this.elementsSupplier = new SupplierOfInstance<List<WebElement>>(elements);
    }

    public ElementListSupplierLocator(Supplier<List<WebElement>> elementsSupplier) {
        this.elementsSupplier = elementsSupplier;
    }

    public WebElement findElement() {
        List<WebElement> webElements = this.elementsSupplier.get();
        if (webElements != null && !webElements.isEmpty()) {
            return webElements.iterator().next();
        }
        return null;
    }

    public List<WebElement> findElements() {
        return this.elementsSupplier.get();
    }

    public String toString() {
        return String.valueOf(this.elementsSupplier);
    }
}

