/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.hook.wait;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.fluentlenium.core.hook.wait.Wait;
import org.fluentlenium.core.wait.FluentWait;

@Wait
public class WaitHookOptions {
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private Long atMost;
    private TimeUnit pollingTimeUnit = TimeUnit.MILLISECONDS;
    private Long pollingEvery;
    private Collection<Class<? extends Throwable>> ignoreAll;
    private boolean withNoDefaultsException;

    public WaitHookOptions() {
        this(WaitHookOptions.class.getAnnotation(Wait.class));
    }

    public WaitHookOptions(Wait annotation) {
        this.timeUnit = annotation.timeUnit();
        this.pollingTimeUnit = annotation.pollingTimeUnit();
        this.atMost = annotation.timeout();
        this.pollingEvery = annotation.pollingInterval();
        this.ignoreAll = new ArrayList<Class<? extends Throwable>>(Arrays.asList(annotation.ignoreAll()));
        this.withNoDefaultsException = annotation.withNoDefaultsException();
    }

    protected FluentWait configureAwait(FluentWait await) {
        if (this.atMost != null) {
            await.atMost(this.atMost, this.timeUnit);
        }
        if (this.pollingEvery != null) {
            await.pollingEvery(this.pollingEvery, this.pollingTimeUnit);
        }
        if (this.withNoDefaultsException) {
            await.withNoDefaultsException();
        }
        if (this.ignoreAll != null) {
            await.ignoreAll((Collection)this.ignoreAll);
        }
        return await;
    }

    public static WaitHookOptionsBuilder builder() {
        return new WaitHookOptionsBuilder();
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public Long getAtMost() {
        return this.atMost;
    }

    public TimeUnit getPollingTimeUnit() {
        return this.pollingTimeUnit;
    }

    public Long getPollingEvery() {
        return this.pollingEvery;
    }

    public Collection<Class<? extends Throwable>> getIgnoreAll() {
        return this.ignoreAll;
    }

    public boolean isWithNoDefaultsException() {
        return this.withNoDefaultsException;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public void setAtMost(Long atMost) {
        this.atMost = atMost;
    }

    public void setPollingTimeUnit(TimeUnit pollingTimeUnit) {
        this.pollingTimeUnit = pollingTimeUnit;
    }

    public void setPollingEvery(Long pollingEvery) {
        this.pollingEvery = pollingEvery;
    }

    public void setIgnoreAll(Collection<Class<? extends Throwable>> ignoreAll) {
        this.ignoreAll = ignoreAll;
    }

    public void setWithNoDefaultsException(boolean withNoDefaultsException) {
        this.withNoDefaultsException = withNoDefaultsException;
    }

    public WaitHookOptions(TimeUnit timeUnit, Long atMost, TimeUnit pollingTimeUnit, Long pollingEvery, Collection<Class<? extends Throwable>> ignoreAll, boolean withNoDefaultsException) {
        this.timeUnit = timeUnit;
        this.atMost = atMost;
        this.pollingTimeUnit = pollingTimeUnit;
        this.pollingEvery = pollingEvery;
        this.ignoreAll = ignoreAll;
        this.withNoDefaultsException = withNoDefaultsException;
    }

    public static class WaitHookOptionsBuilder {
        private TimeUnit timeUnit;
        private Long atMost;
        private TimeUnit pollingTimeUnit;
        private Long pollingEvery;
        private Collection<Class<? extends Throwable>> ignoreAll;
        private boolean withNoDefaultsException;

        WaitHookOptionsBuilder() {
        }

        public WaitHookOptionsBuilder timeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        public WaitHookOptionsBuilder atMost(Long atMost) {
            this.atMost = atMost;
            return this;
        }

        public WaitHookOptionsBuilder pollingTimeUnit(TimeUnit pollingTimeUnit) {
            this.pollingTimeUnit = pollingTimeUnit;
            return this;
        }

        public WaitHookOptionsBuilder pollingEvery(Long pollingEvery) {
            this.pollingEvery = pollingEvery;
            return this;
        }

        public WaitHookOptionsBuilder ignoreAll(Collection<Class<? extends Throwable>> ignoreAll) {
            this.ignoreAll = ignoreAll;
            return this;
        }

        public WaitHookOptionsBuilder withNoDefaultsException(boolean withNoDefaultsException) {
            this.withNoDefaultsException = withNoDefaultsException;
            return this;
        }

        public WaitHookOptions build() {
            return new WaitHookOptions(this.timeUnit, this.atMost, this.pollingTimeUnit, this.pollingEvery, this.ignoreAll, this.withNoDefaultsException);
        }

        public String toString() {
            return "WaitHookOptions.WaitHookOptionsBuilder(timeUnit=" + (Object)((Object)this.timeUnit) + ", atMost=" + this.atMost + ", pollingTimeUnit=" + (Object)((Object)this.pollingTimeUnit) + ", pollingEvery=" + this.pollingEvery + ", ignoreAll=" + this.ignoreAll + ", withNoDefaultsException=" + this.withNoDefaultsException + ")";
        }
    }
}

