/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import com.google.common.collect.ImmutableList;
import java.awt.event.ContainerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.DefaultComponentInstantiator;
import org.fluentlenium.core.events.AlertListener;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventAdapter;
import org.fluentlenium.core.events.EventListener;
import org.fluentlenium.core.events.EventsSupport;
import org.fluentlenium.core.events.ExceptionListener;
import org.fluentlenium.core.events.FindByListener;
import org.fluentlenium.core.events.GetScreenshotAsListener;
import org.fluentlenium.core.events.ListenerPriorityComparator;
import org.fluentlenium.core.events.NavigateAllListener;
import org.fluentlenium.core.events.NavigateListener;
import org.fluentlenium.core.events.NavigateToListener;
import org.fluentlenium.core.events.ScriptListener;
import org.fluentlenium.core.events.SwitchToWindowListener;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class EventsRegistry
implements WrapsDriver {
    private final EventFiringWebDriver eventDriver;
    private final EventsSupport support;
    private final DefaultComponentInstantiator instantiator;
    final List<NavigateToListener> beforeNavigateTo = new ArrayList<NavigateToListener>();
    final List<NavigateToListener> afterNavigateTo = new ArrayList<NavigateToListener>();
    final List<NavigateListener> beforeNavigateBack = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateBack = new ArrayList<NavigateListener>();
    final List<NavigateListener> beforeNavigateForward = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateForward = new ArrayList<NavigateListener>();
    final List<NavigateAllListener> beforeNavigate = new ArrayList<NavigateAllListener>();
    final List<NavigateAllListener> afterNavigate = new ArrayList<NavigateAllListener>();
    final List<NavigateListener> beforeNavigateRefresh = new ArrayList<NavigateListener>();
    final List<NavigateListener> afterNavigateRefresh = new ArrayList<NavigateListener>();
    final List<FindByListener> beforeFindBy = new ArrayList<FindByListener>();
    final List<FindByListener> afterFindBy = new ArrayList<FindByListener>();
    final List<ElementListener> beforeClickOn = new ArrayList<ElementListener>();
    final List<ElementListener> afterClickOn = new ArrayList<ElementListener>();
    final List<ElementListener> beforeGetText = new ArrayList<ElementListener>();
    final List<ElementListener> afterGetText = new ArrayList<ElementListener>();
    final List<ElementListener> beforeChangeValueOf = new ArrayList<ElementListener>();
    final List<ElementListener> afterChangeValueOf = new ArrayList<ElementListener>();
    final List<ScriptListener> beforeScript = new ArrayList<ScriptListener>();
    final List<ScriptListener> afterScript = new ArrayList<ScriptListener>();
    final List<AlertListener> beforeAlertAccept = new ArrayList<AlertListener>();
    final List<AlertListener> afterAlertAccept = new ArrayList<AlertListener>();
    final List<AlertListener> beforeAlertDismiss = new ArrayList<AlertListener>();
    final List<AlertListener> afterAlertDismiss = new ArrayList<AlertListener>();
    final List<SwitchToWindowListener> beforeSwitchToWindow = new ArrayList<SwitchToWindowListener>();
    final List<SwitchToWindowListener> afterSwitchToWindow = new ArrayList<SwitchToWindowListener>();
    final List<GetScreenshotAsListener> beforeGetScreenshotAs = new ArrayList<GetScreenshotAsListener>();
    final List<GetScreenshotAsListener> afterGetScreenshotAs = new ArrayList<GetScreenshotAsListener>();
    final List<ExceptionListener> onException = new ArrayList<ExceptionListener>();
    final List<List> eventLists = ImmutableList.of(this.beforeNavigateTo, this.afterNavigateTo, this.beforeNavigateBack, this.afterNavigateBack, this.beforeNavigateForward, this.afterNavigateForward, this.beforeNavigate, this.afterNavigate, this.beforeNavigateRefresh, this.afterNavigateRefresh, this.beforeFindBy, this.afterFindBy, (Object[])new List[]{this.beforeClickOn, this.afterClickOn, this.beforeChangeValueOf, this.afterChangeValueOf, this.beforeScript, this.afterScript, this.beforeGetText, this.afterGetText, this.beforeGetScreenshotAs, this.afterGetScreenshotAs, this.beforeSwitchToWindow, this.afterSwitchToWindow, this.onException});

    public EventsRegistry(FluentControl control) {
        this.eventDriver = (EventFiringWebDriver)control.getDriver();
        this.support = new EventsSupport(this);
        this.instantiator = new DefaultComponentInstantiator(control);
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(this.support, this.instantiator));
    }

    public EventsRegistry register(WebDriverEventListener eventListener) {
        this.eventDriver.register(eventListener);
        return this;
    }

    public EventsRegistry register(EventListener eventListener) {
        this.eventDriver.register((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public EventsRegistry unregister(EventListener eventListener) {
        this.eventDriver.unregister((WebDriverEventListener)new EventAdapter(eventListener, this.instantiator));
        return this;
    }

    public void close() {
        this.unregister(this.support);
    }

    public WebDriver getWrappedDriver() {
        return this.eventDriver.getWrappedDriver();
    }

    public EventsRegistry beforeNavigateTo(NavigateToListener listener) {
        this.beforeNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateTo(NavigateToListener listener) {
        this.afterNavigateTo.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateBack(NavigateListener listener) {
        this.beforeNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateBack(NavigateListener listener) {
        this.afterNavigateBack.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateForward(NavigateListener listener) {
        this.beforeNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateForward(NavigateListener listener) {
        this.afterNavigateForward.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigate(NavigateAllListener listener) {
        this.beforeNavigate.add(listener);
        return this;
    }

    public EventsRegistry afterNavigate(NavigateAllListener listener) {
        this.afterNavigate.add(listener);
        return this;
    }

    public EventsRegistry beforeNavigateRefresh(NavigateListener listener) {
        this.beforeNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry afterNavigateRefresh(NavigateListener listener) {
        this.afterNavigateRefresh.add(listener);
        return this;
    }

    public EventsRegistry beforeFindBy(FindByListener listener) {
        this.beforeFindBy.add(listener);
        return this;
    }

    public EventsRegistry afterFindBy(FindByListener listener) {
        this.afterFindBy.add(listener);
        return this;
    }

    public EventsRegistry beforeClickOn(ElementListener listener) {
        this.beforeClickOn.add(listener);
        return this;
    }

    public EventsRegistry afterClickOn(ElementListener listener) {
        this.afterClickOn.add(listener);
        return this;
    }

    public EventsRegistry beforeGetText(ElementListener listener) {
        this.beforeGetText.add(listener);
        return this;
    }

    public EventsRegistry afterGetText(ElementListener listener) {
        this.afterGetText.add(listener);
        return this;
    }

    public EventsRegistry beforeChangeValueOf(ElementListener listener) {
        this.beforeChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry afterChangeValueOf(ElementListener listener) {
        this.afterChangeValueOf.add(listener);
        return this;
    }

    public EventsRegistry beforeScript(ScriptListener listener) {
        this.beforeScript.add(listener);
        return this;
    }

    public EventsRegistry afterScript(ScriptListener listener) {
        this.afterScript.add(listener);
        return this;
    }

    public EventsRegistry beforeAlertAccept(AlertListener listener) {
        this.beforeAlertAccept.add(listener);
        return this;
    }

    public EventsRegistry afterAlertAccept(AlertListener listener) {
        this.afterAlertAccept.add(listener);
        return this;
    }

    public EventsRegistry beforeAlertDismiss(AlertListener listener) {
        this.beforeAlertDismiss.add(listener);
        return this;
    }

    public EventsRegistry afterAlertDismiss(AlertListener listener) {
        this.afterAlertDismiss.add(listener);
        return this;
    }

    public EventsRegistry onException(ExceptionListener listener) {
        this.onException.add(listener);
        return this;
    }

    public EventsRegistry afterSwitchToWindow(SwitchToWindowListener listener) {
        this.afterSwitchToWindow.add(listener);
        return this;
    }

    public EventsRegistry beforeSwitchToWindow(SwitchToWindowListener listener) {
        this.beforeSwitchToWindow.add(listener);
        return this;
    }

    public EventsRegistry afterGetScreenshotAs(GetScreenshotAsListener listener) {
        this.afterGetScreenshotAs.add(listener);
        return this;
    }

    public EventsRegistry beforeGetScreenshotAs(GetScreenshotAsListener listener) {
        this.beforeGetScreenshotAs.add(listener);
        return this;
    }

    protected void sortListeners() {
        ListenerPriorityComparator comparator = new ListenerPriorityComparator();
        for (List eventList : this.eventLists) {
            Collections.sort(eventList, comparator);
        }
    }

    public void unregisterContainer(Object container) {
        for (List eventList : this.eventLists) {
            this.unregisterContainer(eventList, container);
        }
    }

    private void unregisterContainer(Iterable iterable, Object container) {
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (!(next instanceof ContainerListener) || next != container) continue;
            iterator.remove();
        }
    }
}

