/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.dom;

import java.util.List;
import java.util.function.Supplier;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Dom {
    private final WebElement webElement;
    private final ComponentInstantiator instantiator;

    public Dom(WebElement element, ComponentInstantiator instantiator) {
        this.webElement = element;
        this.instantiator = instantiator;
    }

    public FluentWebElement parent() {
        WebElement parentElement = LocatorProxies.createWebElement(new Supplier<WebElement>(){

            @Override
            public WebElement get() {
                return Dom.this.webElement.findElement(By.xpath((String)"parent::*"));
            }
        });
        return this.instantiator.newComponent(FluentWebElement.class, parentElement);
    }

    protected FluentList<FluentWebElement> handleAxe(final String axe) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(new Supplier<List<WebElement>>(){

            @Override
            public List<WebElement> get() {
                return Dom.this.webElement.findElements(By.xpath((String)(axe + "::*")));
            }
        });
        return this.instantiator.asComponentList(FluentListImpl.class, FluentWebElement.class, webElementList);
    }

    public FluentList<FluentWebElement> ancestors() {
        return this.handleAxe("ancestor");
    }

    public FluentList<FluentWebElement> descendants() {
        return this.handleAxe("descendant");
    }

    public FluentList<FluentWebElement> followings() {
        return this.handleAxe("following");
    }

    public FluentList<FluentWebElement> followingSiblings() {
        return this.handleAxe("following-sibling");
    }

    public FluentList<FluentWebElement> precedings() {
        return this.handleAxe("preceding");
    }

    public FluentList<FluentWebElement> precedingSiblings() {
        return this.handleAxe("preceding-sibling");
    }
}

