/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions.message;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fluentlenium.core.conditions.Negation;
import org.fluentlenium.core.conditions.message.Message;
import org.fluentlenium.core.conditions.message.MessageBuilderCall;
import org.fluentlenium.core.conditions.message.MessageContext;
import org.fluentlenium.core.conditions.message.MessageProxy;
import org.fluentlenium.core.conditions.message.NotMessage;
import org.fluentlenium.utils.ReflectionUtils;

public class MessageBuilderInvocationHandler
implements InvocationHandler {
    private Object instance;
    private final List<MessageBuilderCall> calls;

    public MessageBuilderInvocationHandler(String context) {
        this(new ArrayList<MessageBuilderCall>());
        MessageBuilderCall messageBuilderCall = new MessageBuilderCall();
        messageBuilderCall.setContext(context);
        this.calls.add(messageBuilderCall);
    }

    public MessageBuilderInvocationHandler(String context, Object instance) {
        this(context);
        this.instance = instance;
    }

    public MessageBuilderInvocationHandler(List<MessageBuilderCall> calls) {
        this.calls = calls;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object instanceReturn = null;
        if (this.instance != null) {
            instanceReturn = method.invoke(this.instance, args);
        }
        MessageBuilderCall callItem = new MessageBuilderCall();
        if (method.isAnnotationPresent(Message.class)) {
            callItem.setMessage(method.getAnnotation(Message.class).value());
        }
        if (method.isAnnotationPresent(NotMessage.class)) {
            callItem.setNotMessage(method.getAnnotation(NotMessage.class).value());
        }
        if (method.isAnnotationPresent(MessageContext.class)) {
            callItem.setContext(method.getAnnotation(MessageContext.class).value());
        }
        callItem.setArgs(args);
        if (method.isAnnotationPresent(Negation.class)) {
            callItem.setNegation(true);
        }
        this.calls.add(callItem);
        if (!method.getReturnType().isPrimitive()) {
            return MessageProxy.wrap(method.getReturnType(), instanceReturn, this.calls);
        }
        if (this.instance == null) {
            return ReflectionUtils.getDefault(method.getReturnType());
        }
        return instanceReturn;
    }

    public String buildMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        for (MessageBuilderCall messageBuilderCall : this.calls) {
            if (messageBuilderCall.getContext() == null) continue;
            if (messageBuilder.length() > 0) {
                messageBuilder.append(' ');
            }
            messageBuilder.append(messageBuilderCall.getContext());
        }
        boolean negation = false;
        for (MessageBuilderCall call : this.calls) {
            if (!call.isNegation()) continue;
            negation = !negation;
        }
        ArrayList<MessageBuilderCall> arrayList = new ArrayList<MessageBuilderCall>(this.calls);
        Collections.reverse(arrayList);
        for (MessageBuilderCall call : arrayList) {
            String validationMessage;
            String string = validationMessage = negation ? call.getMessage() : call.getNotMessage();
            if (validationMessage == null) continue;
            validationMessage = MessageFormat.format(validationMessage, call.getArgs());
            messageBuilder.append(' ');
            messageBuilder.append(validationMessage);
            return messageBuilder.toString();
        }
        throw new IllegalStateException("No @Message/@NotMessage annotation found in the calls.");
    }
}

