/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import java.util.Iterator;
import org.fluentlenium.core.action.BaseFill;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.support.ui.Select;

public class FillSelect<E extends FluentWebElement>
extends BaseFill<E> {
    public FillSelect(FluentList<E> list) {
        super(list);
    }

    public FillSelect(E element) {
        super(element);
    }

    @Override
    protected FluentList<E> getElements() {
        FluentList elements = super.getElements();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            FluentWebElement next = (FluentWebElement)iterator.next();
            if (next.tagName() != null && next.tagName().equalsIgnoreCase("select")) continue;
            iterator.remove();
        }
        return elements;
    }

    public FillSelect withValue(String value) {
        FluentList<E> elements = this.getElements();
        if (elements.size() == 0) {
            throw new NoSuchElementException("No select element found");
        }
        for (FluentWebElement element : elements) {
            Select select = new Select(element.getElement());
            select.selectByValue(value);
        }
        return this;
    }

    public FillSelect withIndex(int index) {
        boolean noSuchElement = true;
        for (FluentWebElement element : this.getElements()) {
            Select select = new Select(element.getElement());
            try {
                select.selectByIndex(index);
                noSuchElement = false;
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
        if (noSuchElement) {
            throw new NoSuchElementException("No select element found with option index=" + index);
        }
        return this;
    }

    public FillSelect withText(String text) {
        FluentList<E> elements = this.getElements();
        if (elements.size() == 0) {
            throw new NoSuchElementException("No select element found");
        }
        for (FluentWebElement element : elements) {
            Select select = new Select(element.getElement());
            select.selectByVisibleText(text);
        }
        return this;
    }
}

