/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.fluentlenium.adapter.SharedWebDriver;
import org.fluentlenium.adapter.SharedWebDriverContainerShutdownHook;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.WebDriver;

public enum SharedWebDriverContainer {
    INSTANCE;

    private final Impl impl = new Impl();
    private final SharedWebDriverContainerShutdownHook shutdownHook = new SharedWebDriverContainerShutdownHook("SharedWebDriverContainerShutdownHook");

    private SharedWebDriverContainer() {
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public <T> SharedWebDriver getOrCreateDriver(Supplier<WebDriver> webDriverFactory, Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
        return this.impl.getOrCreateDriver(webDriverFactory, testClass, testName, driverLifecycle);
    }

    public <T> SharedWebDriver getDriver(Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
        return this.impl.getDriver(testClass, testName, driverLifecycle);
    }

    public void quit(SharedWebDriver driver) {
        this.impl.quit(driver);
    }

    public List<SharedWebDriver> getAllDrivers() {
        return this.impl.getAllDrivers();
    }

    public List<SharedWebDriver> getTestClassDrivers(Class<?> testClass) {
        return this.impl.getTestClassDrivers(testClass);
    }

    public void quitAll() {
        this.impl.quitAll();
    }

    static class Impl {
        private final Map<Class<?>, SharedWebDriver> classDrivers = new HashMap();
        private final Map<ClassAndTestName, SharedWebDriver> methodDrivers = new HashMap<ClassAndTestName, SharedWebDriver>();
        private final Map<ClassAndTestNameWithThreadId, SharedWebDriver> threadDrivers = new HashMap<ClassAndTestNameWithThreadId, SharedWebDriver>();
        private SharedWebDriver jvmDriver;

        Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> SharedWebDriver getOrCreateDriver(Supplier<WebDriver> webDriverFactory, Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
            Impl impl = this;
            synchronized (impl) {
                SharedWebDriver driver = this.getDriver(testClass, testName, driverLifecycle);
                if (driver == null) {
                    driver = this.createDriver(webDriverFactory, testClass, testName, driverLifecycle);
                    this.registerDriver(driver);
                }
                return driver;
            }
        }

        private <T> SharedWebDriver createDriver(Supplier<WebDriver> webDriverFactory, Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
            WebDriver webDriver = webDriverFactory.get();
            return new SharedWebDriver(webDriver, testClass, testName, driverLifecycle);
        }

        private void registerDriver(SharedWebDriver driver) {
            if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.JVM) {
                this.jvmDriver = driver;
            } else if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.CLASS) {
                this.classDrivers.put(driver.getTestClass(), driver);
            } else if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.THREAD) {
                this.threadDrivers.put(new ClassAndTestNameWithThreadId(driver.getTestClass(), driver.getTestName(), Thread.currentThread().getId()), driver);
            } else {
                this.methodDrivers.put(new ClassAndTestName(driver.getTestClass(), driver.getTestName()), driver);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> SharedWebDriver getDriver(Class<T> testClass, String testName, ConfigurationProperties.DriverLifecycle driverLifecycle) {
            Impl impl = this;
            synchronized (impl) {
                SharedWebDriver sharedWebDriver = driverLifecycle == ConfigurationProperties.DriverLifecycle.JVM ? this.jvmDriver : (driverLifecycle == ConfigurationProperties.DriverLifecycle.CLASS ? this.classDrivers.get(testClass) : (driverLifecycle == ConfigurationProperties.DriverLifecycle.THREAD ? this.threadDrivers.get(new ClassAndTestNameWithThreadId(testClass, testName, Thread.currentThread().getId())) : this.methodDrivers.get(new ClassAndTestName(testClass, testName))));
                return sharedWebDriver;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit(SharedWebDriver driver) {
            Impl impl = this;
            synchronized (impl) {
                if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.JVM) {
                    if (this.jvmDriver == driver) {
                        if (this.jvmDriver.getDriver() != null) {
                            this.jvmDriver.getDriver().quit();
                        }
                        this.jvmDriver = null;
                    }
                } else if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.CLASS) {
                    SharedWebDriver classDriver = this.classDrivers.remove(driver.getTestClass());
                    if (classDriver == driver && classDriver.getDriver() != null) {
                        classDriver.getDriver().quit();
                    }
                } else if (driver.getDriverLifecycle() == ConfigurationProperties.DriverLifecycle.THREAD) {
                    List<Map.Entry> threadDriversToClose = this.threadDrivers.entrySet().stream().filter(entry -> ((ClassAndTestNameWithThreadId)entry.getKey()).testClass.equals(driver.getTestClass()) && ((ClassAndTestNameWithThreadId)entry.getKey()).testName.equals(driver.getTestName()) && ((SharedWebDriver)entry.getValue()).getDriver().equals(driver.getDriver())).collect(Collectors.toList());
                    threadDriversToClose.forEach(item -> {
                        SharedWebDriver testThreadDriver = this.threadDrivers.remove(item.getKey());
                        if (testThreadDriver == driver && testThreadDriver.getDriver() != null) {
                            testThreadDriver.getDriver().quit();
                        }
                    });
                } else {
                    SharedWebDriver testDriver = this.methodDrivers.remove(new ClassAndTestName(driver.getTestClass(), driver.getTestName()));
                    if (testDriver == driver && testDriver.getDriver() != null) {
                        testDriver.getDriver().quit();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SharedWebDriver> getAllDrivers() {
            ArrayList<SharedWebDriver> drivers = new ArrayList<SharedWebDriver>();
            Impl impl = this;
            synchronized (impl) {
                if (this.jvmDriver != null) {
                    drivers.add(this.jvmDriver);
                }
                drivers.addAll(this.classDrivers.values());
                drivers.addAll(this.threadDrivers.values());
                drivers.addAll(this.methodDrivers.values());
            }
            return Collections.unmodifiableList(drivers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<SharedWebDriver> getTestClassDrivers(Class<?> testClass) {
            ArrayList<SharedWebDriver> drivers = new ArrayList<SharedWebDriver>();
            Impl impl = this;
            synchronized (impl) {
                SharedWebDriver classDriver = this.classDrivers.get(testClass);
                if (classDriver != null) {
                    drivers.add(classDriver);
                }
                for (SharedWebDriver testDriver : this.methodDrivers.values()) {
                    if (testDriver.getTestClass() != testClass) continue;
                    drivers.add(testDriver);
                }
                for (SharedWebDriver testDriver : this.threadDrivers.values()) {
                    if (testDriver.getTestClass() != testClass) continue;
                    drivers.add(testDriver);
                }
                return Collections.unmodifiableList(drivers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quitAll() {
            Impl impl = this;
            synchronized (impl) {
                if (this.jvmDriver != null) {
                    this.jvmDriver.getDriver().quit();
                    this.jvmDriver = null;
                }
                Iterator<SharedWebDriver> classDriversIterator = this.classDrivers.values().iterator();
                while (classDriversIterator.hasNext()) {
                    classDriversIterator.next().getDriver().quit();
                    classDriversIterator.remove();
                }
                Iterator<SharedWebDriver> testDriversIterator = this.methodDrivers.values().iterator();
                while (testDriversIterator.hasNext()) {
                    testDriversIterator.next().getDriver().quit();
                    testDriversIterator.remove();
                }
                Iterator<SharedWebDriver> testThreadDriversIterator = this.threadDrivers.values().iterator();
                while (testThreadDriversIterator.hasNext()) {
                    testThreadDriversIterator.next().getDriver().quit();
                    testThreadDriversIterator.remove();
                }
            }
        }
    }

    private static class ClassAndTestNameWithThreadId {
        private Class<?> testClass;
        private String testName;
        private Long threadId;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassAndTestNameWithThreadId)) {
                return false;
            }
            ClassAndTestNameWithThreadId other = (ClassAndTestNameWithThreadId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$testClass = this.testClass;
            Class<?> other$testClass = other.testClass;
            if (this$testClass == null ? other$testClass != null : !this$testClass.equals(other$testClass)) {
                return false;
            }
            String this$testName = this.testName;
            String other$testName = other.testName;
            if (this$testName == null ? other$testName != null : !this$testName.equals(other$testName)) {
                return false;
            }
            Long this$threadId = this.threadId;
            Long other$threadId = other.threadId;
            return !(this$threadId == null ? other$threadId != null : !((Object)this$threadId).equals(other$threadId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassAndTestNameWithThreadId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $testClass = this.testClass;
            result = result * 59 + ($testClass == null ? 43 : $testClass.hashCode());
            String $testName = this.testName;
            result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
            Long $threadId = this.threadId;
            result = result * 59 + ($threadId == null ? 43 : ((Object)$threadId).hashCode());
            return result;
        }

        public ClassAndTestNameWithThreadId(Class<?> testClass, String testName, Long threadId) {
            this.testClass = testClass;
            this.testName = testName;
            this.threadId = threadId;
        }
    }

    private static class ClassAndTestName {
        private Class<?> testClass;
        private String testName;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassAndTestName)) {
                return false;
            }
            ClassAndTestName other = (ClassAndTestName)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$testClass = this.testClass;
            Class<?> other$testClass = other.testClass;
            if (this$testClass == null ? other$testClass != null : !this$testClass.equals(other$testClass)) {
                return false;
            }
            String this$testName = this.testName;
            String other$testName = other.testName;
            return !(this$testName == null ? other$testName != null : !this$testName.equals(other$testName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassAndTestName;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $testClass = this.testClass;
            result = result * 59 + ($testClass == null ? 43 : $testClass.hashCode());
            String $testName = this.testName;
            result = result * 59 + ($testName == null ? 43 : $testName.hashCode());
            return result;
        }

        public ClassAndTestName(Class<?> testClass, String testName) {
            this.testClass = testClass;
            this.testName = testName;
        }
    }
}

