/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.utils;

import com.google.common.base.Function;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class ReflectionUtils {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Map<Class<?>, Class<?>> PRIMITIVES_TO_WRAPPERS = new HashMap();
    private static final Map<Class<?>, Object> DEFAULTS = new HashMap();
    private static final Map<ClassAnnotationKey, List<Method>> DECLARED_METHODS_CACHE = new WeakHashMap<ClassAnnotationKey, List<Method>>();

    private ReflectionUtils() {
    }

    public static <T> Class<T> wrapPrimitive(Class<T> clazz) {
        return clazz.isPrimitive() ? PRIMITIVES_TO_WRAPPERS.get(clazz) : clazz;
    }

    public static Class<?>[] toClass(Object ... array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[array.length];
        for (int i = 0; i < array.length; ++i) {
            classes[i] = array[i] == null ? null : array[i].getClass();
        }
        return classes;
    }

    public static Object[] toArgs(Function<Class<?>, Object> valueSupplier, Class<?> ... array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] parameters = new Object[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object value = valueSupplier.apply(array[i]);
            if (value == null) {
                value = DEFAULTS.get(array[i]);
            }
            parameters[i] = value;
        }
        return parameters;
    }

    public static <T> T getDefault(Class<T> type) {
        return (T)DEFAULTS.get(type);
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Object ... args) throws NoSuchMethodException {
        Class<?>[] argsTypes = ReflectionUtils.toClass(args);
        return ReflectionUtils.getConstructor(cls, argsTypes);
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... argsTypes) throws NoSuchMethodException {
        if (argsTypes == null || argsTypes.length == 0) {
            return cls.getDeclaredConstructor(new Class[0]);
        }
        try {
            return cls.getDeclaredConstructor(argsTypes);
        }
        catch (NoSuchMethodException e) {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                if (!ReflectionUtils.isMatchingConstructor(constructor, argsTypes)) continue;
                return constructor;
            }
            throw e;
        }
    }

    private static boolean isMatchingConstructor(Constructor<?> constructor, Class<?>[] argsTypes) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length != argsTypes.length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = ReflectionUtils.wrapPrimitive(parameterTypes[i]);
            if (argsTypes[i] != null) {
                if (parameterTypes[i].isAssignableFrom(argsTypes[i])) continue;
                match = false;
                break;
            }
            if (!parameterTypes[i].isPrimitive()) continue;
            match = false;
            break;
        }
        return match;
    }

    public static <T> Constructor<T> getConstructorOptional(Class<T> cls, Class<?> ... argsTypes) throws NoSuchMethodException {
        return ReflectionUtils.getConstructorOptional(0, cls, argsTypes);
    }

    public static <T> Constructor<T> getConstructorOptional(int mandatoryCount, Class<T> cls, Class<?> ... argsTypes) throws NoSuchMethodException {
        while (true) {
            try {
                return ReflectionUtils.getConstructor(cls, argsTypes);
            }
            catch (NoSuchMethodException e) {
                if (argsTypes.length != mandatoryCount) {
                    argsTypes = Arrays.copyOf(argsTypes, argsTypes.length - 1);
                    continue;
                }
                throw new NoSuchMethodException("Can't find any valid constructor.");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T newInstance(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<T> declaredConstructor = args.length == 0 ? ReflectionUtils.getConstructor(cls, new Class[0]) : ReflectionUtils.getConstructor(cls, args);
        boolean accessible = declaredConstructor.isAccessible();
        if (accessible) {
            return declaredConstructor.newInstance(args);
        }
        declaredConstructor.setAccessible(true);
        try {
            T t = declaredConstructor.newInstance(args);
            return t;
        }
        finally {
            declaredConstructor.setAccessible(accessible);
        }
    }

    public static <T> T newInstanceOptionalArgs(Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return ReflectionUtils.newInstanceOptionalArgs(0, cls, args);
    }

    public static <T> T newInstanceOptionalArgs(int mandatoryCount, Class<T> cls, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        while (true) {
            try {
                return ReflectionUtils.newInstance(cls, args);
            }
            catch (NoSuchMethodException e) {
                if (args.length != mandatoryCount) {
                    args = Arrays.copyOf(args, args.length - 1);
                    continue;
                }
                throw new NoSuchMethodException("Can't find any valid constructor.");
            }
            break;
        }
    }

    public static List<Method> getDeclaredMethodsWithAnnotation(Object object, Class<? extends Annotation> annotation) {
        if (object == null) {
            return ReflectionUtils.getDeclaredMethodsWithAnnotation(null, annotation);
        }
        return ReflectionUtils.getDeclaredMethodsWithAnnotation(object.getClass(), annotation);
    }

    public static List<Method> getDeclaredMethodsWithAnnotation(Class<?> objectClass, Class<? extends Annotation> annotation) {
        Method[] declaredMethods;
        ArrayList<Method> methods = new ArrayList<Method>();
        if (objectClass == null) {
            return methods;
        }
        ClassAnnotationKey cacheKey = new ClassAnnotationKey(objectClass, annotation);
        if (DECLARED_METHODS_CACHE.containsKey(cacheKey)) {
            return DECLARED_METHODS_CACHE.get(cacheKey);
        }
        for (Method method : declaredMethods = objectClass.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            methods.add(method);
        }
        DECLARED_METHODS_CACHE.put(cacheKey, methods);
        return methods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object invoke(Method method, Object obj, Object ... args) throws InvocationTargetException, IllegalAccessException {
        boolean accessible = method.isAccessible();
        if (accessible) {
            return method.invoke(obj, args);
        }
        method.setAccessible(true);
        try {
            Object object = method.invoke(obj, args);
            return object;
        }
        finally {
            method.setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object get(Field field, Object obj) throws IllegalAccessException {
        boolean accessible = field.isAccessible();
        if (accessible) {
            return field.get(obj);
        }
        field.setAccessible(true);
        try {
            Object object = field.get(obj);
            return object;
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void set(Field field, Object obj, Object value) throws IllegalAccessException {
        boolean accessible = field.isAccessible();
        if (accessible) {
            field.set(obj, value);
        }
        field.setAccessible(true);
        try {
            field.set(obj, value);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    public static Class<?> getFirstGenericType(Field field) {
        Type[] actualTypeArguments = ((ParameterizedType)field.getGenericType()).getActualTypeArguments();
        if (actualTypeArguments.length > 0) {
            return (Class)actualTypeArguments[0];
        }
        return null;
    }

    static {
        PRIMITIVES_TO_WRAPPERS.put(Boolean.TYPE, Boolean.class);
        PRIMITIVES_TO_WRAPPERS.put(Byte.TYPE, Byte.class);
        PRIMITIVES_TO_WRAPPERS.put(Character.TYPE, Character.class);
        PRIMITIVES_TO_WRAPPERS.put(Double.TYPE, Double.class);
        PRIMITIVES_TO_WRAPPERS.put(Float.TYPE, Float.class);
        PRIMITIVES_TO_WRAPPERS.put(Integer.TYPE, Integer.class);
        PRIMITIVES_TO_WRAPPERS.put(Long.TYPE, Long.class);
        PRIMITIVES_TO_WRAPPERS.put(Short.TYPE, Short.class);
        PRIMITIVES_TO_WRAPPERS.put(Void.TYPE, Void.class);
        DEFAULTS.put(Boolean.TYPE, false);
        DEFAULTS.put(Character.TYPE, Character.valueOf('\u0000'));
        DEFAULTS.put(Byte.TYPE, (byte)0);
        DEFAULTS.put(Short.TYPE, (short)0);
        DEFAULTS.put(Integer.TYPE, 0);
        DEFAULTS.put(Long.TYPE, 0L);
        DEFAULTS.put(Float.TYPE, Float.valueOf(0.0f));
        DEFAULTS.put(Double.TYPE, 0.0);
    }

    private static class ClassAnnotationKey {
        private Class<?> clazz;
        private Class<? extends Annotation> annotation;

        public Class<?> getClazz() {
            return this.clazz;
        }

        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        public void setClazz(Class<?> clazz) {
            this.clazz = clazz;
        }

        public void setAnnotation(Class<? extends Annotation> annotation) {
            this.annotation = annotation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassAnnotationKey)) {
                return false;
            }
            ClassAnnotationKey other = (ClassAnnotationKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$clazz = this.getClazz();
            Class<?> other$clazz = other.getClazz();
            if (this$clazz == null ? other$clazz != null : !this$clazz.equals(other$clazz)) {
                return false;
            }
            Class<? extends Annotation> this$annotation = this.getAnnotation();
            Class<? extends Annotation> other$annotation = other.getAnnotation();
            return !(this$annotation == null ? other$annotation != null : !this$annotation.equals(other$annotation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClassAnnotationKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $clazz = this.getClazz();
            result = result * 59 + ($clazz == null ? 43 : $clazz.hashCode());
            Class<? extends Annotation> $annotation = this.getAnnotation();
            result = result * 59 + ($annotation == null ? 43 : $annotation.hashCode());
            return result;
        }

        @ConstructorProperties(value={"clazz", "annotation"})
        public ClassAnnotationKey(Class<?> clazz, Class<? extends Annotation> annotation) {
            this.clazz = clazz;
            this.annotation = annotation;
        }
    }
}

