/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.wait;

import com.google.common.base.Predicate;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.wait.BaseWaitConditions;
import org.fluentlenium.core.wait.FluentWait;

public class FluentWaitWindowConditions
extends BaseWaitConditions {
    private final FluentWait wait;
    private final String windowName;

    protected FluentWaitWindowConditions(FluentWait wait, String windowName) {
        this.wait = wait;
        this.windowName = windowName;
    }

    public boolean displayed() {
        Predicate<FluentControl> displayed = new Predicate<FluentControl>(){

            public boolean apply(FluentControl fluent) {
                return fluent.getDriver().getWindowHandles().contains(FluentWaitWindowConditions.this.windowName);
            }
        };
        this.until(this.wait, displayed, String.format("Window %s should be displayed.", this.windowName));
        return true;
    }

    public boolean notDisplayed() {
        Predicate<FluentControl> notDisplayed = new Predicate<FluentControl>(){

            public boolean apply(FluentControl fluent) {
                return !fluent.getDriver().getWindowHandles().contains(FluentWaitWindowConditions.this.windowName);
            }
        };
        this.until(this.wait, notDisplayed, String.format("Window %s should not be displayed.", this.windowName));
        return true;
    }
}

