/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.proxy;

import com.google.common.base.Supplier;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fluentlenium.core.domain.ElementUtils;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.HookChainBuilder;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.proxy.LocatorHandler;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.proxy.ProxyElementListener;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public abstract class AbstractLocatorHandler<T>
implements InvocationHandler,
LocatorHandler<T> {
    private static final Method TO_STRING = AbstractLocatorHandler.getMethod(Object.class, "toString", new Class[0]);
    private static final Method EQUALS = AbstractLocatorHandler.getMethod(Object.class, "equals", Object.class);
    private static final Method HASH_CODE = AbstractLocatorHandler.getMethod(Object.class, "hashCode", new Class[0]);
    private static final int MAX_RETRY = 5;
    private static final int HASH_CODE_SEED = 2048;
    protected HookChainBuilder hookChainBuilder;
    protected List<HookDefinition<?>> hookDefinitions;
    private final List<ProxyElementListener> listeners = new ArrayList<ProxyElementListener>();
    protected T proxy;
    protected final ElementLocator locator;
    protected T result;
    protected List<FluentHook> hooks;

    protected static Method getMethod(Class<?> declaringClass, String name, Class ... types) {
        try {
            return declaringClass.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public boolean addListener(ProxyElementListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ProxyElementListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireProxyElementSearch() {
        for (ProxyElementListener listener : this.listeners) {
            listener.proxyElementSearch(this.proxy, this.locator);
        }
    }

    protected void fireProxyElementFound(T result) {
        for (ProxyElementListener listener : this.listeners) {
            listener.proxyElementFound(this.proxy, this.locator, this.resultToList(result));
        }
    }

    protected abstract List<WebElement> resultToList(T var1);

    public AbstractLocatorHandler(ElementLocator locator) {
        this.locator = locator;
    }

    public void setProxy(T proxy) {
        this.proxy = proxy;
    }

    public abstract T getLocatorResultImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getLocatorResult() {
        AbstractLocatorHandler abstractLocatorHandler = this;
        synchronized (abstractLocatorHandler) {
            if (this.result != null && this.isStale()) {
                this.result = null;
            }
            if (this.result == null) {
                this.fireProxyElementSearch();
                this.result = this.getLocatorResultImpl();
                this.fireProxyElementFound(this.result);
            }
            return this.result;
        }
    }

    protected abstract boolean isStale();

    protected abstract WebElement getElement();

    @Override
    public NoSuchElementException noSuchElement() {
        return ElementUtils.noSuchElementException(this.getMessageContext());
    }

    @Override
    public void setHooks(HookChainBuilder hookChainBuilder, List<HookDefinition<?>> hookDefinitions) {
        if (hookDefinitions == null || hookDefinitions.isEmpty()) {
            this.hookChainBuilder = null;
            this.hookDefinitions = null;
            this.hooks = null;
        } else {
            this.hookChainBuilder = hookChainBuilder;
            this.hookDefinitions = hookDefinitions;
            this.hooks = hookChainBuilder.build(new Supplier<WebElement>(){

                public WebElement get() {
                    return AbstractLocatorHandler.this.getElement();
                }
            }, new Supplier<ElementLocator>(){

                public ElementLocator get() {
                    return AbstractLocatorHandler.this.locator;
                }
            }, new Supplier<String>(){

                public String get() {
                    return AbstractLocatorHandler.this.proxy.toString();
                }
            }, hookDefinitions);
        }
    }

    @Override
    public ElementLocator getLocator() {
        return this.locator;
    }

    @Override
    public ElementLocator getHookLocator() {
        if (this.hooks != null && !this.hooks.isEmpty()) {
            return this.hooks.get(this.hooks.size() - 1);
        }
        return this.locator;
    }

    @Override
    public boolean loaded() {
        return this.result != null;
    }

    @Override
    public boolean present() {
        try {
            this.now();
        }
        catch (NoSuchElementException | StaleElementReferenceException | TimeoutException e) {
            return false;
        }
        return this.result != null && !this.isStale();
    }

    @Override
    public void reset() {
        this.result = null;
    }

    @Override
    public void now() {
        this.getLocatorResult();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        LocatorHandler otherLocatorHandler;
        if (TO_STRING.equals(method)) {
            return this.proxyToString(this.result == null ? null : (String)this.invoke(method, args));
        }
        if (this.result == null) {
            if (EQUALS.equals(method) && (otherLocatorHandler = LocatorProxies.getLocatorHandler(args[0])) != null) {
                if (!otherLocatorHandler.loaded() || args[0] == null) {
                    return this.equals(otherLocatorHandler);
                }
                return args[0].equals(proxy);
            }
            if (HASH_CODE.equals(method)) {
                return 2048 + this.locator.hashCode();
            }
        }
        if (EQUALS.equals(method) && (otherLocatorHandler = LocatorProxies.getLocatorHandler(args[0])) != null && !otherLocatorHandler.loaded()) {
            otherLocatorHandler.now();
            return otherLocatorHandler.equals(this);
        }
        this.getLocatorResult();
        return this.invokeWithRetry(method, args);
    }

    private Object invokeWithRetry(Method method, Object[] args) throws Throwable {
        StaleElementReferenceException lastThrowable = null;
        for (int i = 0; i < 5; ++i) {
            try {
                return this.invoke(method, args);
            }
            catch (StaleElementReferenceException e) {
                lastThrowable = e;
                this.reset();
                this.getLocatorResult();
                continue;
            }
        }
        throw lastThrowable;
    }

    private Object invoke(Method method, Object[] args) throws Throwable {
        Object returnValue;
        try {
            returnValue = method.invoke(this.getInvocationTarget(method), args);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return returnValue;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractLocatorHandler that = (AbstractLocatorHandler)obj;
        return Objects.equals(this.locator, that.locator);
    }

    public int hashCode() {
        return Objects.hash(this.locator);
    }

    protected String getLazyToString() {
        return "Lazy Element";
    }

    public String proxyToString(String elementToString) {
        if (elementToString == null) {
            elementToString = this.getLazyToString();
        }
        if (this.locator instanceof WrapsElement) {
            return elementToString;
        }
        return this.locator + " (" + elementToString + ")";
    }

    public String toString() {
        return this.proxyToString(null);
    }
}

