/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.inject;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.fluentlenium.core.FluentContainer;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.components.ComponentsManager;
import org.fluentlenium.core.components.LazyComponents;
import org.fluentlenium.core.components.LazyComponentsListener;
import org.fluentlenium.core.domain.ComponentList;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.ContainerAnnotationsEventsRegistry;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.hook.DefaultHookChainBuilder;
import org.fluentlenium.core.hook.FluentHook;
import org.fluentlenium.core.hook.Hook;
import org.fluentlenium.core.hook.HookControlImpl;
import org.fluentlenium.core.hook.HookDefinition;
import org.fluentlenium.core.hook.HookOptions;
import org.fluentlenium.core.hook.NoHook;
import org.fluentlenium.core.inject.ContainerContext;
import org.fluentlenium.core.inject.ContainerFluentControl;
import org.fluentlenium.core.inject.ContainerInstanciator;
import org.fluentlenium.core.inject.DefaultContainerContext;
import org.fluentlenium.core.inject.ElementLocatorSearchContext;
import org.fluentlenium.core.inject.FluentInjectControl;
import org.fluentlenium.core.inject.FluentInjectException;
import org.fluentlenium.core.inject.InjectionElementLocator;
import org.fluentlenium.core.inject.InjectionElementLocatorFactory;
import org.fluentlenium.core.inject.NoInject;
import org.fluentlenium.core.inject.Parent;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class FluentInjector
implements FluentInjectControl {
    private final Map<Class, Object> containerInstances = new IdentityHashMap<Class, Object>();
    private final Map<Object, ContainerContext> containerContexts = new IdentityHashMap<Object, ContainerContext>();
    private final Map<Object, ContainerAnnotationsEventsRegistry> eventsContainerSupport = new IdentityHashMap<Object, ContainerAnnotationsEventsRegistry>();
    private final FluentControl fluentControl;
    private final ComponentsManager componentsManager;
    private final ContainerInstanciator containerInstanciator;
    private final DefaultHookChainBuilder hookChainBuilder;
    private final EventsRegistry eventsRegistry;

    public FluentInjector(FluentControl control, EventsRegistry eventsRegistry, ComponentsManager componentsManager, ContainerInstanciator instanciator) {
        this.fluentControl = control;
        this.eventsRegistry = eventsRegistry;
        this.componentsManager = componentsManager;
        this.containerInstanciator = instanciator;
        this.hookChainBuilder = new DefaultHookChainBuilder(control, componentsManager.getInstantiator());
    }

    public void release() {
        this.containerInstances.clear();
        for (ContainerAnnotationsEventsRegistry support : this.eventsContainerSupport.values()) {
            support.close();
        }
        this.eventsContainerSupport.clear();
        this.containerContexts.clear();
        this.componentsManager.release();
    }

    @Override
    public <T> T newInstance(Class<T> cls) {
        T container = this.containerInstanciator.newInstance(cls, null);
        this.inject((Object)container);
        return container;
    }

    @Override
    public ContainerContext[] inject(Object ... containers) {
        ContainerContext[] context = new ContainerContext[containers.length];
        for (int i = 0; i < containers.length; ++i) {
            context[i] = this.inject(containers[i]);
        }
        return context;
    }

    @Override
    public ContainerContext inject(Object container) {
        this.inject(container, (Object)null, (SearchContext)this.fluentControl.getDriver());
        return this.containerContexts.get(container);
    }

    private void inject(Object container, Object parentContainer, SearchContext searchContext) {
        this.initContainer(container, parentContainer, searchContext);
        this.initParentContainer(container, parentContainer);
        this.initFluentElements(container, searchContext);
        this.initChildrenContainers(container, searchContext);
    }

    private void injectComponent(Object componentContainer, Object parentContainer, SearchContext searchContext) {
        this.initContainerContext(componentContainer, parentContainer, searchContext);
        this.initParentContainer(componentContainer, parentContainer);
        this.initFluentElements(componentContainer, searchContext);
        this.initChildrenContainers(componentContainer, searchContext);
    }

    private void initParentContainer(Object container, Object parentContainer) {
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!this.isParent(field)) continue;
                try {
                    ReflectionUtils.set(field, container, parentContainer);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new FluentInjectException("Can't set field " + field + " with value " + parentContainer, e);
                }
            }
            cls = cls.getSuperclass();
        }
    }

    private boolean isParent(Field field) {
        return field.isAnnotationPresent(Parent.class);
    }

    private void initContainer(Object container, Object parentContainer, SearchContext searchContext) {
        this.initContainerContext(container, parentContainer, searchContext);
        if (container instanceof FluentContainer) {
            ((FluentContainer)container).initFluent(new ContainerFluentControl(this.fluentControl, this.containerContexts.get(container)));
        }
        this.initEventAnnotations(container);
    }

    private void initContainerContext(Object container, Object parentContainer, SearchContext searchContext) {
        ContainerContext parentContainerContext = parentContainer == null ? null : this.containerContexts.get(parentContainer);
        DefaultContainerContext containerContext = new DefaultContainerContext(container, parentContainerContext, searchContext);
        this.containerContexts.put(container, containerContext);
        if (parentContainerContext != null) {
            containerContext.getHookDefinitions().addAll(parentContainerContext.getHookDefinitions());
        }
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            this.addHookDefinitions(cls.getDeclaredAnnotations(), containerContext.getHookDefinitions());
            cls = cls.getSuperclass();
        }
    }

    private void initEventAnnotations(Object container) {
        if (this.eventsRegistry != null) {
            this.eventsContainerSupport.put(container, new ContainerAnnotationsEventsRegistry(this.eventsRegistry, container));
        }
    }

    private static boolean isContainer(Field field) {
        return field.isAnnotationPresent(Page.class);
    }

    private static boolean isClassSupported(Class<?> cls) {
        return cls != Object.class && cls != null;
    }

    private void initChildrenContainers(Object container, SearchContext searchContext) {
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!FluentInjector.isContainer(field)) continue;
                Class<?> fieldClass = field.getType();
                Object existingChildContainer = this.containerInstances.get(fieldClass);
                if (existingChildContainer == null) {
                    Object childContainer = this.containerInstanciator.newInstance(fieldClass, this.containerContexts.get(container));
                    this.initContainer(childContainer, container, searchContext);
                    try {
                        ReflectionUtils.set(field, container, childContainer);
                    }
                    catch (IllegalAccessException e) {
                        throw new FluentInjectException("Can't set field " + field + " with value " + childContainer, e);
                    }
                    this.containerInstances.put(fieldClass, childContainer);
                    this.inject(childContainer, container, searchContext);
                    continue;
                }
                try {
                    ReflectionUtils.set(field, container, existingChildContainer);
                }
                catch (IllegalAccessException e) {
                    throw new FluentInjectException("Can't set field " + field + " with value " + existingChildContainer, e);
                }
            }
            cls = cls.getSuperclass();
        }
    }

    private void initFluentElements(Object container, SearchContext searchContext) {
        ContainerContext containerContext = this.containerContexts.get(container);
        Class<?> cls = container.getClass();
        while (FluentInjector.isClassSupported(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!this.isSupported(container, field)) continue;
                ArrayList fieldHookDefinitions = new ArrayList(containerContext.getHookDefinitions());
                this.addHookDefinitions(field.getAnnotations(), fieldHookDefinitions);
                InjectionElementLocatorFactory locatorFactory = new InjectionElementLocatorFactory(searchContext);
                InjectionElementLocator locator = locatorFactory.createLocator(field);
                if (locator == null) continue;
                ComponentAndProxy<?, ?> fieldValue = this.initFieldElements(locator, field);
                this.injectComponent(fieldValue, locator, container, field, fieldHookDefinitions);
            }
            cls = cls.getSuperclass();
        }
    }

    private void injectComponent(ComponentAndProxy fieldValue, ElementLocator locator, final Object container, Field field, ArrayList<HookDefinition<?>> fieldHookDefinitions) {
        if (fieldValue != null) {
            LocatorProxies.setHooks(fieldValue.getProxy(), this.hookChainBuilder, fieldHookDefinitions);
            try {
                ReflectionUtils.set(field, container, fieldValue.getComponent());
            }
            catch (IllegalAccessException e) {
                throw new FluentInjectException("Unable to find an accessible constructor with an argument of type WebElement in " + field.getType(), e);
            }
            if (fieldValue.getComponent() instanceof Iterable) {
                if (this.isLazyComponentsAndNotInitialized(fieldValue.getComponent())) {
                    LazyComponents lazyComponents = (LazyComponents)fieldValue.getComponent();
                    lazyComponents.addLazyComponentsListener(new LazyComponentsListener<Object>(){

                        @Override
                        public void lazyComponentsInitialized(Map<WebElement, Object> componentMap) {
                            for (Map.Entry<WebElement, Object> componentEntry : componentMap.entrySet()) {
                                FluentInjector.this.injectComponent(componentEntry.getValue(), container, (SearchContext)componentEntry.getKey());
                            }
                        }
                    });
                }
            } else {
                ElementLocatorSearchContext componentSearchContext = new ElementLocatorSearchContext(locator);
                this.injectComponent(fieldValue.getComponent(), container, componentSearchContext);
            }
        }
    }

    private boolean isLazyComponentsAndNotInitialized(Object component) {
        if (component instanceof LazyComponents) {
            LazyComponents lazyComponents = (LazyComponents)component;
            return lazyComponents.isLazy() && !lazyComponents.isLazyInitialized();
        }
        return false;
    }

    private Hook getHookAnnotation(Annotation annotation) {
        if (annotation instanceof Hook) {
            return (Hook)annotation;
        }
        if (annotation.annotationType().isAnnotationPresent(Hook.class)) {
            return annotation.annotationType().getAnnotation(Hook.class);
        }
        return null;
    }

    private HookOptions getHookOptionsAnnotation(Annotation annotation) {
        if (annotation instanceof HookOptions) {
            return (HookOptions)annotation;
        }
        if (annotation.annotationType().isAnnotationPresent(HookOptions.class)) {
            return annotation.annotationType().getAnnotation(HookOptions.class);
        }
        return null;
    }

    private void addHookDefinitions(Annotation[] annotations, List<HookDefinition<?>> hookDefinitions) {
        Hook currentHookAnnotation = null;
        HookOptions currentHookOptionAnnotation = null;
        Annotation currentAnnotation = null;
        for (Annotation annotation : annotations) {
            HookOptions hookOptionsAnnotation;
            this.applyNoHook(hookDefinitions, annotation);
            Hook hookAnnotation = this.getHookAnnotation(annotation);
            if (hookAnnotation != null) {
                currentAnnotation = annotation;
            }
            if (hookAnnotation != null && currentHookAnnotation != null) {
                hookDefinitions.add(this.buildHookDefinition(currentHookAnnotation, currentHookOptionAnnotation, currentAnnotation));
                currentHookAnnotation = null;
                currentHookOptionAnnotation = null;
            }
            if (hookAnnotation != null) {
                currentHookAnnotation = hookAnnotation;
            }
            if ((hookOptionsAnnotation = this.getHookOptionsAnnotation(annotation)) == null) continue;
            if (currentHookOptionAnnotation != null) {
                throw new FluentInjectException("Unexpected @HookOptions annotation. @Hook is missing.");
            }
            currentHookOptionAnnotation = hookOptionsAnnotation;
        }
        if (currentHookAnnotation != null) {
            hookDefinitions.add(this.buildHookDefinition(currentHookAnnotation, currentHookOptionAnnotation, currentAnnotation));
        }
    }

    private void applyNoHook(List<HookDefinition<?>> hookDefinitions, Annotation annotation) {
        if (annotation instanceof NoHook) {
            Object[] value = ((NoHook)annotation).value();
            if (ArrayUtils.isEmpty((Object[])value)) {
                hookDefinitions.clear();
            } else {
                List<Class> toRemove = Arrays.stream(value).map(Hook::value).collect(Collectors.toList());
                HookControlImpl.removeHooksFromDefinitions(hookDefinitions, toRemove.toArray(new Class[toRemove.size()]));
            }
        }
    }

    private <T> HookDefinition<T> buildHookDefinition(Hook hookAnnotation, HookOptions hookOptionsAnnotation, Annotation currentAnnotation) {
        Class<?> hookOptionsClass = hookOptionsAnnotation == null ? null : hookOptionsAnnotation.value();
        Object fluentHookOptions = null;
        if (hookOptionsClass != null) {
            try {
                fluentHookOptions = ReflectionUtils.newInstanceOptionalArgs(hookOptionsClass, currentAnnotation);
            }
            catch (NoSuchMethodException e) {
                throw new FluentInjectException("@HookOption class has no valid constructor", e);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new FluentInjectException("Can't create @HookOption class instance", e);
            }
        }
        Class<? extends FluentHook<?>> hookClass = hookAnnotation.value();
        if (fluentHookOptions == null) {
            return new HookDefinition(hookClass);
        }
        return new HookDefinition<Object>((Class<FluentHook<Object>>)hookClass, fluentHookOptions);
    }

    private boolean isSupported(Object container, Field field) {
        return FluentInjector.isValueNull(container, field) && !field.isAnnotationPresent(NoInject.class) && !Modifier.isFinal(field.getModifiers()) && (FluentInjector.isListOfFluentWebElement(field) || this.isListOfComponent(field) || this.isComponent(field) || this.isComponentList(field) || FluentInjector.isElement(field) || FluentInjector.isListOfElement(field));
    }

    private static boolean isValueNull(Object container, Field field) {
        try {
            return ReflectionUtils.get(field, container) == null;
        }
        catch (IllegalAccessException e) {
            throw new FluentInjectException("Can't retrieve default value of field", e);
        }
    }

    private boolean isComponent(Field field) {
        return this.componentsManager.isComponentClass(field.getType());
    }

    private boolean isComponentList(Field field) {
        Class<?> genericType;
        boolean componentClass;
        boolean componentListClass;
        return FluentInjector.isList(field) && (componentListClass = this.componentsManager.isComponentListClass(field.getType())) && (componentClass = this.componentsManager.isComponentClass(genericType = ReflectionUtils.getFirstGenericType(field)));
    }

    private static boolean isListOfFluentWebElement(Field field) {
        if (FluentInjector.isList(field)) {
            Class<?> genericType = ReflectionUtils.getFirstGenericType(field);
            return FluentWebElement.class.isAssignableFrom(genericType);
        }
        return false;
    }

    private boolean isListOfComponent(Field field) {
        if (FluentInjector.isList(field)) {
            Class<?> genericType = ReflectionUtils.getFirstGenericType(field);
            return this.componentsManager.isComponentClass(genericType);
        }
        return false;
    }

    private static boolean isList(Field field) {
        return List.class.isAssignableFrom(field.getType());
    }

    private static boolean isElement(Field field) {
        return WebElement.class.isAssignableFrom(field.getType());
    }

    private static boolean isListOfElement(Field field) {
        if (FluentInjector.isList(field)) {
            Class<?> genericType = ReflectionUtils.getFirstGenericType(field);
            return WebElement.class.isAssignableFrom(genericType);
        }
        return false;
    }

    private ComponentAndProxy<?, ?> initFieldElements(ElementLocator locator, Field field) {
        if (this.isComponent(field)) {
            return this.initFieldAsComponent(locator, field);
        }
        if (this.isComponentList(field)) {
            return this.initFieldAsComponentList(locator, field);
        }
        if (FluentInjector.isListOfFluentWebElement(field)) {
            return this.initFieldAsListOfFluentWebElement(locator, field);
        }
        if (this.isListOfComponent(field)) {
            return this.initFieldAsListOfComponent(locator, field);
        }
        if (FluentInjector.isElement(field)) {
            return this.initFieldAsElement(locator);
        }
        if (FluentInjector.isListOfElement(field)) {
            return this.initFieldAsListOfElement(locator);
        }
        return null;
    }

    private <L extends List<T>, T> ComponentAndProxy<L, List<WebElement>> initFieldAsComponentList(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        Object componentList = this.componentsManager.asComponentList(field.getType(), ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy(componentList, webElementList);
    }

    private ComponentAndProxy<Object, WebElement> initFieldAsComponent(ElementLocator locator, Field field) {
        WebElement element = LocatorProxies.createWebElement(locator);
        Object component = this.componentsManager.newComponent(field.getType(), element);
        return new ComponentAndProxy<Object, WebElement>(component, element);
    }

    private ComponentAndProxy<ComponentList<?>, List<WebElement>> initFieldAsListOfComponent(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        ComponentList<?> componentList = this.componentsManager.asComponentList(ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy(componentList, webElementList);
    }

    private ComponentAndProxy<FluentList<? extends FluentWebElement>, List<WebElement>> initFieldAsListOfFluentWebElement(ElementLocator locator, Field field) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(locator);
        FluentList<?> fluentList = this.componentsManager.asFluentList(ReflectionUtils.getFirstGenericType(field), webElementList);
        return new ComponentAndProxy<FluentList<? extends FluentWebElement>, List<WebElement>>(fluentList, webElementList);
    }

    private ComponentAndProxy<WebElement, WebElement> initFieldAsElement(ElementLocator locator) {
        WebElement element = LocatorProxies.createWebElement(locator);
        return new ComponentAndProxy<WebElement, WebElement>(element, element);
    }

    private ComponentAndProxy<List<WebElement>, List<WebElement>> initFieldAsListOfElement(ElementLocator locator) {
        List<WebElement> elements = LocatorProxies.createWebElementList(locator);
        return new ComponentAndProxy<List<WebElement>, List<WebElement>>(elements, elements);
    }

    private static class ComponentAndProxy<T, P> {
        private T component;
        private P proxy;

        @ConstructorProperties(value={"component", "proxy"})
        public ComponentAndProxy(T component, P proxy) {
            this.component = component;
            this.proxy = proxy;
        }

        public T getComponent() {
            return this.component;
        }

        public P getProxy() {
            return this.proxy;
        }
    }
}

