/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.ElementListener;
import org.fluentlenium.core.events.EventListener;
import org.fluentlenium.core.events.EventsRegistry;
import org.fluentlenium.core.events.ExceptionListener;
import org.fluentlenium.core.events.FindByListener;
import org.fluentlenium.core.events.NavigateAllListener;
import org.fluentlenium.core.events.NavigateListener;
import org.fluentlenium.core.events.NavigateToListener;
import org.fluentlenium.core.events.ScriptListener;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class EventsSupport
implements EventListener {
    private final EventsRegistry eventsRegistry;

    public EventsSupport(EventsRegistry eventsRegistry) {
        this.eventsRegistry = eventsRegistry;
    }

    @Override
    public void beforeNavigateTo(String url, WebDriver driver) {
        for (NavigateToListener navigateToListener : this.eventsRegistry.beforeNavigateTo) {
            navigateToListener.on(url, driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.beforeNavigate) {
            navigateAllListener.on(url, driver, null);
        }
    }

    @Override
    public void afterNavigateTo(String url, WebDriver driver) {
        for (NavigateToListener navigateToListener : this.eventsRegistry.afterNavigateTo) {
            navigateToListener.on(url, driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.afterNavigate) {
            navigateAllListener.on(url, driver, null);
        }
    }

    @Override
    public void beforeNavigateBack(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.beforeNavigateBack) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.beforeNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.BACK);
        }
    }

    @Override
    public void afterNavigateBack(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.afterNavigateBack) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.afterNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.BACK);
        }
    }

    @Override
    public void beforeNavigateForward(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.beforeNavigateForward) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.beforeNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.FORWARD);
        }
    }

    @Override
    public void afterNavigateForward(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.afterNavigateForward) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.afterNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.FORWARD);
        }
    }

    @Override
    public void beforeNavigateRefresh(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.beforeNavigateRefresh) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.beforeNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.REFRESH);
        }
    }

    @Override
    public void afterNavigateRefresh(WebDriver driver) {
        for (NavigateListener navigateListener : this.eventsRegistry.afterNavigateRefresh) {
            navigateListener.on(driver);
        }
        for (NavigateAllListener navigateAllListener : this.eventsRegistry.afterNavigate) {
            navigateAllListener.on(null, driver, NavigateAllListener.Direction.REFRESH);
        }
    }

    @Override
    public void beforeFindBy(By by, FluentWebElement element, WebDriver driver) {
        for (FindByListener listener : this.eventsRegistry.beforeFindBy) {
            listener.on(by, element, driver);
        }
    }

    @Override
    public void afterFindBy(By by, FluentWebElement element, WebDriver driver) {
        for (FindByListener listener : this.eventsRegistry.afterFindBy) {
            listener.on(by, element, driver);
        }
    }

    @Override
    public void beforeClickOn(FluentWebElement element, WebDriver driver) {
        for (ElementListener listener : this.eventsRegistry.beforeClickOn) {
            listener.on(element, driver);
        }
    }

    @Override
    public void afterClickOn(FluentWebElement element, WebDriver driver) {
        for (ElementListener listener : this.eventsRegistry.afterClickOn) {
            listener.on(element, driver);
        }
    }

    @Override
    public void beforeChangeValueOf(FluentWebElement element, WebDriver driver, CharSequence[] charSequence) {
        for (ElementListener listener : this.eventsRegistry.beforeChangeValueOf) {
            listener.on(element, driver);
        }
    }

    @Override
    public void afterChangeValueOf(FluentWebElement element, WebDriver driver, CharSequence[] charSequence) {
        for (ElementListener listener : this.eventsRegistry.afterChangeValueOf) {
            listener.on(element, driver);
        }
    }

    @Override
    public void beforeScript(String script, WebDriver driver) {
        for (ScriptListener listener : this.eventsRegistry.beforeScript) {
            listener.on(script, driver);
        }
    }

    @Override
    public void afterScript(String script, WebDriver driver) {
        for (ScriptListener listener : this.eventsRegistry.afterScript) {
            listener.on(script, driver);
        }
    }

    @Override
    public void onException(Throwable throwable, WebDriver driver) {
        for (ExceptionListener listener : this.eventsRegistry.onException) {
            listener.on(throwable, driver);
        }
    }
}

