/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import java.util.Objects;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.events.EventListener;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

class EventAdapter
implements WebDriverEventListener {
    private final EventListener listener;
    private final ComponentInstantiator instantiator;

    EventAdapter(EventListener listener, ComponentInstantiator instantiator) {
        this.listener = listener;
        this.instantiator = instantiator;
    }

    public void beforeNavigateTo(String url, WebDriver driver) {
        this.listener.beforeNavigateTo(url, driver);
    }

    public void afterNavigateTo(String url, WebDriver driver) {
        this.listener.afterNavigateTo(url, driver);
    }

    public void beforeNavigateBack(WebDriver driver) {
        this.listener.beforeNavigateBack(driver);
    }

    public void afterNavigateBack(WebDriver driver) {
        this.listener.afterNavigateBack(driver);
    }

    public void beforeNavigateForward(WebDriver driver) {
        this.listener.beforeNavigateForward(driver);
    }

    public void afterNavigateForward(WebDriver driver) {
        this.listener.afterNavigateForward(driver);
    }

    public void beforeNavigateRefresh(WebDriver driver) {
        this.listener.beforeNavigateRefresh(driver);
    }

    public void afterNavigateRefresh(WebDriver driver) {
        this.listener.afterNavigateRefresh(driver);
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        this.listener.beforeFindBy(by, element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void afterFindBy(By by, WebElement element, WebDriver driver) {
        this.listener.afterFindBy(by, element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.listener.beforeClickOn(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        this.listener.afterClickOn(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver);
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.listener.beforeChangeValueOf(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver, charSequence);
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.listener.afterChangeValueOf(element == null ? null : this.instantiator.newComponent(FluentWebElement.class, element), driver, charSequence);
    }

    public void beforeScript(String script, WebDriver driver) {
        this.listener.beforeScript(script, driver);
    }

    public void afterScript(String script, WebDriver driver) {
        this.listener.afterScript(script, driver);
    }

    public void onException(Throwable throwable, WebDriver driver) {
        this.listener.onException(throwable, driver);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EventAdapter that = (EventAdapter)obj;
        return Objects.equals(this.listener, that.listener);
    }

    public int hashCode() {
        return Objects.hash(this.listener);
    }
}

