/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import com.google.common.base.Function;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.fluentlenium.core.components.ComponentsAccessor;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.annotations.AfterChangeValueOf;
import org.fluentlenium.core.events.annotations.AfterClickOn;
import org.fluentlenium.core.events.annotations.AfterFindBy;
import org.fluentlenium.core.events.annotations.BeforeChangeValueOf;
import org.fluentlenium.core.events.annotations.BeforeClickOn;
import org.fluentlenium.core.events.annotations.BeforeFindBy;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;

public class AnnotationsComponentListener
implements WebDriverEventListener {
    private final ComponentsAccessor componentsAccessor;

    public AnnotationsComponentListener(ComponentsAccessor componentsAccessor) {
        this.componentsAccessor = componentsAccessor;
    }

    protected void findByHandler(Class<? extends Annotation> annotation, By by, WebElement element, WebDriver driver) {
        if (element == null) {
            return;
        }
        Set<Object> components = this.componentsAccessor.getComponents(element);
        if (components == null) {
            return;
        }
        for (Object component : components) {
            for (Method method : ReflectionUtils.getDeclaredMethodsWithAnnotation(component, annotation)) {
                this.findByHandlerComponentMethod(component, method, annotation, by);
            }
        }
    }

    protected void findByHandlerComponentMethod(Object component, Method method, Class<? extends Annotation> annotation, final By by) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(new Function<Class<?>, Object>(){

            public Object apply(Class<?> input) {
                if (input.isAssignableFrom(By.class)) {
                    return by;
                }
                return null;
            }
        }, parameterTypes);
        try {
            ReflectionUtils.invoke(method, component, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in @BeforeFindBy " + method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in @BeforeFindBy " + method, e);
        }
    }

    public void beforeFindBy(By by, WebElement element, WebDriver driver) {
        this.findByHandler(BeforeFindBy.class, by, element, driver);
    }

    public void afterFindBy(By by, WebElement element, WebDriver driver) {
        this.findByHandler(AfterFindBy.class, by, element, driver);
    }

    protected void defaultHandler(Class<? extends Annotation> annotation, WebElement element, CharSequence[] charSequence) {
        if (element == null) {
            return;
        }
        Set<Object> components = this.componentsAccessor.getComponents(element);
        if (components == null) {
            return;
        }
        for (Object component : components) {
            for (Method method : ReflectionUtils.getDeclaredMethodsWithAnnotation(component, annotation)) {
                this.defaultHandlerComponentMethod(component, method, annotation, charSequence);
            }
        }
    }

    protected void defaultHandlerComponentMethod(Object component, Method method, Class<? extends Annotation> annotation, final CharSequence[] charSequence) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(new Function<Class<?>, Object>(){

            public Object apply(Class<?> input) {
                if (CharSequence.class.isAssignableFrom(input)) {
                    return charSequence;
                }
                return null;
            }
        }, parameterTypes);
        try {
            ReflectionUtils.invoke(method, component, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in @" + annotation.getSimpleName() + " " + method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in @" + annotation.getSimpleName() + " " + method, e);
        }
    }

    public void beforeClickOn(WebElement element, WebDriver driver) {
        this.defaultHandler(BeforeClickOn.class, element, null);
    }

    public void afterClickOn(WebElement element, WebDriver driver) {
        this.defaultHandler(AfterClickOn.class, element, null);
    }

    public void beforeChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.defaultHandler(BeforeChangeValueOf.class, element, charSequence);
    }

    public void afterChangeValueOf(WebElement element, WebDriver driver, CharSequence[] charSequence) {
        this.defaultHandler(AfterChangeValueOf.class, element, charSequence);
    }

    public void beforeNavigateTo(String url, WebDriver driver) {
    }

    public void afterNavigateTo(String url, WebDriver driver) {
    }

    public void beforeNavigateBack(WebDriver driver) {
    }

    public void afterNavigateBack(WebDriver driver) {
    }

    public void beforeNavigateForward(WebDriver driver) {
    }

    public void afterNavigateForward(WebDriver driver) {
    }

    public void beforeNavigateRefresh(WebDriver driver) {
    }

    public void afterNavigateRefresh(WebDriver driver) {
    }

    public void beforeScript(String script, WebDriver driver) {
    }

    public void afterScript(String script, WebDriver driver) {
    }

    public void onException(Throwable throwable, WebDriver driver) {
    }
}

