/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.events;

import com.google.common.base.Function;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.fluentlenium.core.events.EventAnnotationsException;
import org.fluentlenium.core.events.ListenerPriority;
import org.fluentlenium.core.events.ScriptListener;
import org.fluentlenium.utils.ReflectionUtils;
import org.openqa.selenium.WebDriver;

class AnnotationScriptListener
implements ScriptListener,
ListenerPriority {
    private final Method method;
    private final Object container;
    private final String annotationName;
    private final int priority;

    AnnotationScriptListener(Method method, Object container, String annotationName, int priority) {
        this.method = method;
        this.container = container;
        this.annotationName = annotationName;
        this.priority = priority;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    protected Function<Class<?>, Object> getArgsFunction(final String script, final WebDriver driver) {
        return new Function<Class<?>, Object>(){

            public Object apply(Class<?> input) {
                if (input.isAssignableFrom(String.class)) {
                    return script;
                }
                if (input.isAssignableFrom(WebDriver.class)) {
                    return driver;
                }
                return null;
            }
        };
    }

    @Override
    public void on(String script, WebDriver driver) {
        Class<?>[] parameterTypes = this.method.getParameterTypes();
        Object[] args = ReflectionUtils.toArgs(this.getArgsFunction(script, driver), parameterTypes);
        try {
            ReflectionUtils.invoke(this.method, this.container, args);
        }
        catch (IllegalAccessException e) {
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new EventAnnotationsException("An error has occured in " + this.annotationName + " " + this.method, e);
        }
    }
}

