/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fluentlenium.core.conditions.AbstractObjectConditions;
import org.fluentlenium.core.conditions.Negation;
import org.fluentlenium.core.conditions.StringConditions;

public class StringConditionsImpl
extends AbstractObjectConditions<String>
implements StringConditions {
    public StringConditionsImpl(String string) {
        super(string);
    }

    public StringConditionsImpl(String string, boolean negation) {
        super(string, negation);
    }

    protected StringConditionsImpl newInstance(boolean negationValue) {
        return new StringConditionsImpl((String)this.object, negationValue);
    }

    @Override
    @Negation
    public StringConditionsImpl not() {
        return (StringConditionsImpl)super.not();
    }

    @Override
    public boolean contains(final CharSequence charSequence) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.contains(charSequence);
            }
        });
    }

    @Override
    public boolean startsWith(final String prefix) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.startsWith(prefix);
            }
        });
    }

    @Override
    public boolean endsWith(final String suffix) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.endsWith(suffix);
            }
        });
    }

    @Override
    public boolean equalTo(final String anotherString) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.equals(anotherString);
            }
        });
    }

    @Override
    public boolean equalToIgnoreCase(final String anotherString) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.equalsIgnoreCase(anotherString);
            }
        });
    }

    @Override
    public boolean matches(final String regex) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                return input.matches(regex);
            }
        });
    }

    @Override
    public boolean matches(final Pattern pattern) {
        return this.verify(new Predicate<String>(){

            public boolean apply(String input) {
                if (input == null) {
                    return false;
                }
                Matcher matcher = pattern.matcher(input);
                return matcher.matches();
            }
        });
    }
}

