/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import org.fluentlenium.core.FluentDriver;
import org.fluentlenium.core.conditions.AbstractFluentListConditions;
import org.fluentlenium.core.domain.FluentWebElement;

public class EachElementConditions
extends AbstractFluentListConditions {
    public EachElementConditions(List<? extends FluentWebElement> elements) {
        super(elements);
    }

    @Override
    public EachElementConditions not() {
        EachElementConditions negatedConditions = new EachElementConditions(this.getElements());
        negatedConditions.setNegation(!this.isNegation());
        return negatedConditions;
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate, boolean defaultValue) {
        if (this.isNegation()) {
            predicate = Predicates.not(predicate);
            defaultValue = !defaultValue;
        }
        return this.buildEachElementPredicate((Predicate<FluentWebElement>)predicate, defaultValue).apply(null);
    }

    protected Predicate<FluentDriver> buildEachElementPredicate(final Predicate<FluentWebElement> predicate, final boolean defaultValue) {
        Predicate<FluentDriver> untilPredicate = new Predicate<FluentDriver>(){

            public boolean apply(FluentDriver fluent) {
                if (EachElementConditions.this.getElements().size() > 0) {
                    for (FluentWebElement fluentWebElement : EachElementConditions.this.getElements()) {
                        if (predicate.apply((Object)fluentWebElement)) continue;
                        return false;
                    }
                    return true;
                }
                return defaultValue;
            }
        };
        return untilPredicate;
    }
}

