/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Predicate;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.ConditionsObject;
import org.fluentlenium.core.conditions.Negation;

public abstract class AbstractObjectConditions<T>
implements Conditions<T>,
ConditionsObject<T> {
    protected final T object;
    protected boolean negation;

    public AbstractObjectConditions(T object) {
        this.object = object;
    }

    public AbstractObjectConditions(T object, boolean negation) {
        this.object = object;
        this.negation = negation;
    }

    @Override
    public boolean verify(Predicate<T> predicate) {
        boolean predicateResult = predicate.apply(this.object);
        if (this.negation) {
            predicateResult = !predicateResult;
        }
        return predicateResult;
    }

    @Override
    public T getActualObject() {
        return this.object;
    }

    protected abstract AbstractObjectConditions<T> newInstance(boolean var1);

    @Override
    @Negation
    public AbstractObjectConditions<T> not() {
        return this.newInstance(!this.negation);
    }
}

