/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.conditions;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import org.fluentlenium.core.conditions.Conditions;
import org.fluentlenium.core.conditions.FluentListConditions;
import org.fluentlenium.core.conditions.IntegerConditions;
import org.fluentlenium.core.conditions.IntegerConditionsImpl;
import org.fluentlenium.core.conditions.ListConditionsElements;
import org.fluentlenium.core.conditions.RectangleConditions;
import org.fluentlenium.core.conditions.RectangleListConditionsImpl;
import org.fluentlenium.core.conditions.StringConditions;
import org.fluentlenium.core.conditions.StringListConditionsImpl;
import org.fluentlenium.core.domain.FluentWebElement;

public abstract class AbstractFluentListConditions
implements FluentListConditions,
ListConditionsElements {
    private boolean negation;
    private final List<? extends FluentWebElement> elements;

    protected AbstractFluentListConditions(List<? extends FluentWebElement> elements) {
        this.elements = elements;
    }

    @Override
    public boolean size(int size) {
        if (this.negation) {
            return this.elements.size() != size;
        }
        return this.elements.size() == size;
    }

    protected boolean isNegation() {
        return this.negation;
    }

    public void setNegation(boolean negation) {
        this.negation = negation;
    }

    protected List<? extends FluentWebElement> getElements() {
        return this.elements;
    }

    @Override
    public List<? extends FluentWebElement> getActualElements() {
        return this.elements;
    }

    @Override
    public IntegerConditions size() {
        return new IntegerConditionsImpl(this.elements.size(), this.negation);
    }

    @Override
    public boolean verify(Predicate<FluentWebElement> predicate) {
        return this.verify(predicate, false);
    }

    @Override
    public boolean present() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().present();
            }
        }, false);
    }

    @Override
    public boolean clickable() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().clickable();
            }
        }, false);
    }

    @Override
    public boolean stale() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().stale();
            }
        }, false);
    }

    @Override
    public boolean displayed() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().displayed();
            }
        }, false);
    }

    @Override
    public boolean enabled() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().enabled();
            }
        }, false);
    }

    @Override
    public boolean selected() {
        return this.verify(new Predicate<FluentWebElement>(){

            public boolean apply(FluentWebElement input) {
                return input.conditions().selected();
            }
        }, false);
    }

    @Override
    public boolean attribute(String name, String value) {
        return this.attribute(name).equalTo(value);
    }

    @Override
    public StringConditions attribute(final String name) {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.attribute(name);
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().attribute(name);
            }
        });
    }

    @Override
    public boolean id(String id) {
        return this.id().equalTo(id);
    }

    @Override
    public StringConditions id() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.id();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().id();
            }
        });
    }

    @Override
    public StringConditions name() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.name();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().name();
            }
        });
    }

    @Override
    public boolean name(String name) {
        return this.name().equalTo(name);
    }

    @Override
    public StringConditions tagName() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.tagName();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().tagName();
            }
        });
    }

    @Override
    public boolean tagName(String tagName) {
        return this.tagName().equalTo(tagName);
    }

    @Override
    public StringConditions value() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.value();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().value();
            }
        });
    }

    @Override
    public boolean value(String value) {
        return this.value().equalTo(value);
    }

    @Override
    public StringConditions text() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.text();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().text();
            }
        });
    }

    @Override
    public boolean text(String text) {
        return this.text().equalTo(text);
    }

    @Override
    public StringConditions textContent() {
        return new StringListConditionsImpl((Conditions<FluentWebElement>)this, new Function<FluentWebElement, String>(){

            public String apply(FluentWebElement input) {
                return input.textContent();
            }
        }, new Function<FluentWebElement, StringConditions>(){

            public StringConditions apply(FluentWebElement input) {
                return input.conditions().textContent();
            }
        });
    }

    @Override
    public boolean textContent(String anotherString) {
        return this.textContent().equalTo(anotherString);
    }

    @Override
    public RectangleConditions rectangle() {
        return new RectangleListConditionsImpl(this);
    }
}

