/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.components;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.fluentlenium.core.FluentControl;
import org.fluentlenium.core.components.AbstractComponentInstantiator;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.components.ComponentsAccessor;
import org.fluentlenium.core.components.DefaultComponentInstantiator;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.fluentlenium.core.proxy.ProxyElementListener;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsElement;
import org.openqa.selenium.support.pagefactory.ElementLocator;

public class ComponentsManager
extends AbstractComponentInstantiator
implements ComponentInstantiator,
ComponentsAccessor,
ProxyElementListener {
    private final FluentControl control;
    private final DefaultComponentInstantiator instantiator;
    private final Map<WebElement, Set<Object>> components = new IdentityHashMap<WebElement, Set<Object>>();

    public ComponentsManager(FluentControl control) {
        this.control = control;
        this.instantiator = new DefaultComponentInstantiator(this.control, this);
    }

    public ComponentInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public Set<Object> getComponents(WebElement element) {
        return this.components.get(this.unwrapElement(element));
    }

    @Override
    public boolean isComponentClass(Class<?> componentClass) {
        return this.instantiator.isComponentClass(componentClass);
    }

    @Override
    public boolean isComponentListClass(Class<? extends List<?>> componentListClass) {
        return this.instantiator.isComponentListClass(componentListClass);
    }

    @Override
    public <T> T newComponent(Class<T> componentClass, WebElement element) {
        T component = this.instantiator.newComponent(componentClass, element);
        this.register(element, component);
        return component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void register(WebElement element, T component) {
        WebElement webElement = this.unwrapElement(element);
        LocatorProxies.addProxyListener(webElement, this);
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            Set<Object> elementComponents = this.components.get(webElement);
            if (elementComponents == null) {
                elementComponents = new HashSet<Object>();
                this.components.put(webElement, elementComponents);
            }
            elementComponents.add(component);
        }
    }

    @Override
    public <L extends List<T>, T> L newComponentList(Class<L> listClass, Class<T> componentClass, List<T> componentsList) {
        return this.instantiator.newComponentList(listClass, componentClass, componentsList);
    }

    @Override
    public <L extends List<T>, T> L asComponentList(Class<L> listClass, Class<T> componentClass, Iterable<WebElement> elementList) {
        L componentList = this.instantiator.asComponentList(listClass, componentClass, elementList);
        int i = 0;
        for (WebElement element : elementList) {
            this.register(element, componentList.get(i));
            ++i;
        }
        return componentList;
    }

    @Override
    public void proxyElementSearch(Object proxy, ElementLocator locator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void proxyElementFound(Object proxy, ElementLocator locator, List<WebElement> elements) {
        ComponentsManager componentsManager = this;
        synchronized (componentsManager) {
            for (WebElement element : elements) {
                Set<Object> proxyComponents = this.components.remove(proxy);
                if (proxyComponents == null) continue;
                this.components.put(this.unwrapElement(element), proxyComponents);
            }
        }
    }

    private WebElement unwrapElement(WebElement element) {
        WebElement wrappedElement;
        if (element instanceof WrapsElement && (wrappedElement = ((WrapsElement)element).getWrappedElement()) != element && wrappedElement != null) {
            return this.unwrapElement(wrappedElement);
        }
        return element;
    }

    public void release() {
        for (WebElement element : this.components.keySet()) {
            LocatorProxies.removeProxyListener(element, this);
        }
        this.components.clear();
    }
}

