/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.axes;

import com.google.common.base.Supplier;
import java.util.List;
import org.fluentlenium.core.components.ComponentInstantiator;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.proxy.LocatorProxies;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class Axes {
    private final WebElement webElement;
    private final ComponentInstantiator instantiator;

    public Axes(WebElement element, ComponentInstantiator instantiator) {
        this.webElement = element;
        this.instantiator = instantiator;
    }

    public FluentWebElement parent() {
        WebElement parentElement = LocatorProxies.createWebElement(new Supplier<WebElement>(){

            public WebElement get() {
                return Axes.this.webElement.findElement(By.xpath((String)"parent::*"));
            }
        });
        return this.instantiator.newComponent(FluentWebElement.class, parentElement);
    }

    protected FluentList<FluentWebElement> handleAxe(final String axe) {
        List<WebElement> webElementList = LocatorProxies.createWebElementList(new Supplier<List<WebElement>>(){

            public List<WebElement> get() {
                return Axes.this.webElement.findElements(By.xpath((String)(axe + "::*")));
            }
        });
        return this.instantiator.asComponentList(FluentListImpl.class, FluentWebElement.class, webElementList);
    }

    public FluentList<FluentWebElement> ancestors() {
        return this.handleAxe("ancestor");
    }

    public FluentList<FluentWebElement> descendants() {
        return this.handleAxe("descendant");
    }

    public FluentList<FluentWebElement> followings() {
        return this.handleAxe("following");
    }

    public FluentList<FluentWebElement> followingSiblings() {
        return this.handleAxe("following-sibling");
    }

    public FluentList<FluentWebElement> precedings() {
        return this.handleAxe("preceding");
    }

    public FluentList<FluentWebElement> precedingSiblings() {
        return this.handleAxe("preceding-sibling");
    }
}

