/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public class MouseActions {
    private WebDriver driver;
    private Keyboard keyboard;
    private Mouse mouse;

    public MouseActions(WebDriver driver) {
        this.driver = driver;
    }

    public MouseActions(Keyboard keyboard, Mouse mouse) {
        this.keyboard = keyboard;
        this.mouse = mouse;
    }

    protected Actions actions() {
        if (this.driver == null) {
            return new Actions(this.keyboard, this.mouse);
        }
        return new Actions(this.driver);
    }

    public Mouse basic() {
        if (this.mouse == null) {
            return ((HasInputDevices)this.driver).getMouse();
        }
        return this.mouse;
    }

    public MouseActions clickAndHold() {
        this.actions().clickAndHold().perform();
        return this;
    }

    public MouseActions release() {
        this.actions().release().perform();
        return this;
    }

    public MouseActions click() {
        this.actions().click().perform();
        return this;
    }

    public MouseActions doubleClick() {
        this.actions().doubleClick().perform();
        return this;
    }

    public MouseActions contextClick() {
        this.actions().contextClick().perform();
        return this;
    }
}

