/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.action;

import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;

public class KeyboardActions {
    private WebDriver driver;
    private Keyboard keyboard;
    private Mouse mouse;

    public KeyboardActions(WebDriver driver) {
        this.driver = driver;
    }

    public KeyboardActions(Keyboard keyboard, Mouse mouse) {
        this.keyboard = keyboard;
        this.mouse = mouse;
    }

    protected Actions actions() {
        if (this.driver == null) {
            return new Actions(this.keyboard, this.mouse);
        }
        return new Actions(this.driver);
    }

    public Keyboard basic() {
        if (this.keyboard == null) {
            return ((HasInputDevices)this.driver).getKeyboard();
        }
        return this.keyboard;
    }

    public KeyboardActions keyDown(Keys theKey) {
        this.actions().keyDown(theKey).perform();
        return this;
    }

    public KeyboardActions keyUp(Keys theKey) {
        this.actions().keyUp(theKey).perform();
        return this;
    }

    public KeyboardActions sendKeys(CharSequence ... keysToSend) {
        this.actions().sendKeys(keysToSend).perform();
        return this;
    }
}

