/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.configuration;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.atteo.classindex.ClassIndex;
import org.fluentlenium.configuration.ConfigurationException;
import org.fluentlenium.configuration.DefaultFactory;
import org.fluentlenium.configuration.Factory;
import org.fluentlenium.configuration.FactoryName;
import org.fluentlenium.configuration.FactoryNames;
import org.fluentlenium.configuration.FactoryPriority;
import org.fluentlenium.configuration.IndexIgnore;
import org.fluentlenium.configuration.ReflectiveFactory;

public abstract class AbstractFactoryRegistryImpl<T extends Factory, R extends ReflectiveFactory> {
    protected final Class<T> factoryType;
    protected final Class<R> reflectiveFactoryType;
    protected Map<String, T> factories = new LinkedHashMap<String, T>();

    public AbstractFactoryRegistryImpl(Class<T> factoryType, Class<R> reflectiveFactoryType) {
        this.factoryType = factoryType;
        this.reflectiveFactoryType = reflectiveFactoryType;
        Iterable factoryClasses = ClassIndex.getSubclasses(factoryType);
        block3: for (Class factoryClass : factoryClasses) {
            Factory factory;
            if (factoryClass.isAnnotationPresent(IndexIgnore.class)) continue;
            for (Class<?> iface : factoryClass.getInterfaces()) {
                if (iface.isAnnotationPresent(IndexIgnore.class)) continue block3;
            }
            if (Modifier.isAbstract(factoryClass.getModifiers()) || !Modifier.isPublic(factoryClass.getModifiers())) continue;
            try {
                factory = (Factory)factoryClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException(factoryClass + " should have a public default constructor.", e);
            }
            catch (Exception e) {
                throw new ConfigurationException(factoryClass + " can't be instantiated.", e);
            }
            this.register(factory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getDefault() {
        ArrayList<T> factoriesList;
        AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
        synchronized (abstractFactoryRegistryImpl) {
            factoriesList = new ArrayList<T>(this.factories.values());
        }
        Collections.sort(factoriesList, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                FactoryPriority annotation1 = o1.getClass().getAnnotation(FactoryPriority.class);
                int p1 = annotation1 == null ? 0 : annotation1.value();
                FactoryPriority annotation2 = o2.getClass().getAnnotation(FactoryPriority.class);
                int p2 = annotation2 == null ? 0 : annotation2.value();
                return Integer.compare(p2, p1);
            }
        });
        ArrayList<Factory> filteredFactories = new ArrayList<Factory>();
        for (Factory factory : factoriesList) {
            if (factory instanceof ReflectiveFactory) {
                if (!((ReflectiveFactory)factory).isAvailable()) continue;
                filteredFactories.add(factory);
                continue;
            }
            filteredFactories.add(factory);
        }
        return (T)this.getDefault(filteredFactories);
    }

    protected abstract T getDefault(List<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(String name) {
        if (name == null) {
            return this.getDefault();
        }
        AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
        synchronized (abstractFactoryRegistryImpl) {
            Factory factory = (Factory)this.factories.get(name);
            if (factory == null) {
                R reflectiveFactory = this.newReflectiveInstance(name);
                if (reflectiveFactory.isAvailable()) {
                    this.factories.put(name, reflectiveFactory);
                    factory = reflectiveFactory;
                } else {
                    this.handleNoFactoryAvailable(name);
                }
            }
            return (T)factory;
        }
    }

    protected abstract void handleNoFactoryAvailable(String var1);

    protected abstract R newReflectiveInstance(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void register(T factory) {
        FactoryName annotation = factory.getClass().getAnnotation(FactoryName.class);
        String annotationName = annotation == null ? null : annotation.value();
        ArrayList<String> names = new ArrayList<String>();
        if (annotationName != null) {
            names.add(annotationName);
        }
        if (factory instanceof FactoryNames) {
            names.addAll(Arrays.asList(((FactoryNames)factory).getNames()));
        }
        if (names.isEmpty()) {
            throw new ConfigurationException("Factory " + factory.getClass().getName() + " has no name defined. Use @FactoryName annotation or implement FactoryNames.");
        }
        AbstractFactoryRegistryImpl abstractFactoryRegistryImpl = this;
        synchronized (abstractFactoryRegistryImpl) {
            this.registerImpl(names, factory);
        }
    }

    private void registerImpl(List<String> names, T factory) {
        boolean registered = false;
        for (String name : names) {
            if (!registered) {
                Factory exitingFactory;
                if (this.factories.containsKey(name) && !(exitingFactory = (Factory)this.factories.get(name)).getClass().isAnnotationPresent(DefaultFactory.class)) {
                    throw new ConfigurationException("A factory is already registered with this name: " + name + " (" + this.factories.get(name) + ")");
                }
                this.factories.put(name, factory);
                registered = true;
            }
            if (this.factories.containsKey(name)) continue;
            this.factories.put(name, factory);
        }
    }
}

