/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.adapter;

import com.google.common.base.Supplier;
import java.util.List;
import org.fluentlenium.adapter.DefaultFluentControlContainer;
import org.fluentlenium.adapter.DefaultSharedMutator;
import org.fluentlenium.adapter.FluentAdapter;
import org.fluentlenium.adapter.FluentControlContainer;
import org.fluentlenium.adapter.SharedMutator;
import org.fluentlenium.adapter.SharedWebDriver;
import org.fluentlenium.adapter.SharedWebDriverContainer;
import org.fluentlenium.configuration.ConfigurationProperties;
import org.openqa.selenium.WebDriver;

public class FluentTestRunnerAdapter
extends FluentAdapter {
    private final SharedMutator sharedMutator;

    public FluentTestRunnerAdapter() {
        this(new DefaultFluentControlContainer());
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer) {
        this(driverContainer, new DefaultSharedMutator());
    }

    public FluentTestRunnerAdapter(SharedMutator sharedMutator) {
        this(new DefaultFluentControlContainer(), sharedMutator);
    }

    public FluentTestRunnerAdapter(FluentControlContainer driverContainer, SharedMutator sharedMutator) {
        super(driverContainer);
        this.sharedMutator = sharedMutator;
    }

    protected void starting() {
        this.starting(this.getClass());
    }

    protected void starting(String testName) {
        this.starting(this.getClass(), testName);
    }

    protected void starting(Class<?> testClass) {
        this.starting(testClass, testClass.getName());
    }

    protected void starting(Class<?> testClass, String testName) {
        SharedMutator.EffectiveParameters<?> parameters = this.sharedMutator.getEffectiveParameters(testClass, testName, this.getDriverLifecycle());
        SharedWebDriver sharedWebDriver = SharedWebDriverContainer.INSTANCE.getOrCreateDriver(new Supplier<WebDriver>(){

            public WebDriver get() {
                return FluentTestRunnerAdapter.this.newWebDriver();
            }
        }, parameters.getTestClass(), parameters.getTestName(), parameters.getDriverLifecycle());
        this.initFluent(sharedWebDriver.getDriver());
    }

    protected void finished() {
        this.finished(this.getClass());
    }

    protected void finished(String testName) {
        this.finished(this.getClass(), testName);
    }

    protected void finished(Class<?> testClass) {
        this.finished(testClass, testClass.getName());
    }

    protected void finished(Class<?> testClass, String testName) {
        SharedMutator.EffectiveParameters<?> sharedParameters;
        SharedWebDriver sharedWebDriver;
        ConfigurationProperties.DriverLifecycle driverLifecycle = this.getDriverLifecycle();
        if (driverLifecycle == ConfigurationProperties.DriverLifecycle.METHOD) {
            SharedMutator.EffectiveParameters<?> parameters = this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle);
            SharedWebDriver sharedWebDriver2 = SharedWebDriverContainer.INSTANCE.getDriver(parameters.getTestClass(), parameters.getTestName(), parameters.getDriverLifecycle());
            if (sharedWebDriver2 != null) {
                SharedWebDriverContainer.INSTANCE.quit(sharedWebDriver2);
            }
        } else if (this.getDeleteCookies() != null && this.getDeleteCookies().booleanValue() && (sharedWebDriver = SharedWebDriverContainer.INSTANCE.getDriver((sharedParameters = this.sharedMutator.getEffectiveParameters(testClass, testName, driverLifecycle)).getTestClass(), sharedParameters.getTestName(), sharedParameters.getDriverLifecycle())) != null) {
            sharedWebDriver.getDriver().manage().deleteAllCookies();
        }
        this.releaseFluent();
    }

    public static void afterClass(Class<?> testClass) {
        List<SharedWebDriver> sharedWebDrivers = SharedWebDriverContainer.INSTANCE.getTestClassDrivers(testClass);
        for (SharedWebDriver sharedWebDriver : sharedWebDrivers) {
            SharedWebDriverContainer.INSTANCE.quit(sharedWebDriver);
        }
    }

    protected void failed() {
        this.failed(this.getClass());
    }

    protected void failed(String testName) {
        this.failed(this.getClass(), testName);
    }

    protected void failed(Class<?> testClass) {
        this.failed(testClass, testClass.getName());
    }

    protected void failed(Class<?> testClass, String testName) {
        this.failed(null, testClass, testName);
    }

    protected void failed(Throwable e, Class<?> testClass, String testName) {
        if (this.isFluentControlAvailable()) {
            try {
                if (this.getScreenshotMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.canTakeScreenShot()) {
                    this.takeScreenShot(testClass.getSimpleName() + "_" + testName + ".png");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.getHtmlDumpMode() == ConfigurationProperties.TriggerMode.AUTOMATIC_ON_FAIL && this.getDriver() != null) {
                    this.takeHtmlDump(testClass.getSimpleName() + "_" + testName + ".html");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

