/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core.domain;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.filter.Filter;
import org.openqa.selenium.NoSuchElementException;

public class FluentListImpl<E extends FluentWebElement>
extends ArrayList<E>
implements FluentList<E> {
    public FluentListImpl(Collection<E> listFiltered) {
        super(listFiltered);
    }

    @Override
    public E first() {
        if (this.size() == 0) {
            throw new NoSuchElementException("Element not found");
        }
        return (E)((FluentWebElement)this.get(0));
    }

    @Override
    public FluentList click() {
        if (this.size() == 0) {
            throw new NoSuchElementException("No Element found");
        }
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.click();
        }
        return this;
    }

    @Override
    public FluentList text(String ... with) {
        boolean atMostOne = false;
        if (with.length > 0) {
            int id = 0;
            for (FluentWebElement fluentWebElement : this) {
                if (!fluentWebElement.isDisplayed()) continue;
                String value = with.length > id ? with[id++] : with[with.length - 1];
                if (!fluentWebElement.isEnabled()) continue;
                atMostOne = true;
                fluentWebElement.text(value);
            }
            if (!atMostOne) {
                throw new NoSuchElementException("No element is displayed or enabled. Can't set a new value.");
            }
        }
        return this;
    }

    @Override
    public FluentList<E> clearAll() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.clear();
        }
        return this;
    }

    @Override
    public void clear() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.clear();
        }
    }

    @Override
    public FluentList<E> submit() {
        for (FluentWebElement fluentWebElement : this) {
            if (!fluentWebElement.isEnabled()) continue;
            fluentWebElement.submit();
        }
        return this;
    }

    @Override
    public List<String> getValues() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getValue();
            }
        });
    }

    @Override
    public List<String> getIds() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getId();
            }
        });
    }

    @Override
    public List<String> getAttributes(final String attribute) {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getAttribute(attribute);
            }
        });
    }

    @Override
    public List<String> getNames() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getName();
            }
        });
    }

    @Override
    public List<String> getTextContents() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getTextContent();
            }
        });
    }

    @Override
    public List<String> getTexts() {
        return Lists.transform((List)this, (Function)new Function<E, String>(){

            public String apply(E webElement) {
                return ((FluentWebElement)webElement).getText();
            }
        });
    }

    @Override
    public String getValue() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getValue();
        }
        return null;
    }

    @Override
    public String getId() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getId();
        }
        return null;
    }

    @Override
    public String getAttribute(String attribute) {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getAttribute(attribute);
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getName();
        }
        return null;
    }

    @Override
    public String getText() {
        if (this.size() > 0) {
            return ((FluentWebElement)this.get(0)).getText();
        }
        return null;
    }

    @Override
    public FluentList<E> find(String name, Filter ... filters) {
        ArrayList<FluentWebElement> finds = new ArrayList<FluentWebElement>();
        for (FluentWebElement e : this) {
            finds.addAll(e.find(name, filters));
        }
        return new FluentListImpl(finds);
    }

    @Override
    public FluentList<E> find(Filter ... filters) {
        ArrayList<FluentWebElement> finds = new ArrayList<FluentWebElement>();
        for (FluentWebElement e : this) {
            finds.addAll(e.find(filters));
        }
        return new FluentListImpl(finds);
    }

    @Override
    public E find(String name, Integer number, Filter ... filters) {
        FluentList<E> fluentList = this.find(name, filters);
        if (number >= fluentList.size()) {
            throw new NoSuchElementException("No such element with position: " + number + ". Number of elements available: " + fluentList.size() + ". Selector: " + name + ".");
        }
        return (E)((FluentWebElement)fluentList.get(number));
    }

    @Override
    public E find(Integer number, Filter ... filters) {
        FluentList<E> fluentList = this.find(filters);
        if (number >= fluentList.size()) {
            throw new NoSuchElementException("No such element with position: " + number + ". Number of elements available: " + fluentList.size() + ".");
        }
        return (E)((FluentWebElement)fluentList.get(number));
    }

    @Override
    public E findFirst(String name, Filter ... filters) {
        return this.find(name, 0, filters);
    }

    @Override
    public E findFirst(Filter ... filters) {
        return this.find(0, filters);
    }
}

