/*
 * Decompiled with CFR 0.152.
 */
package org.fluentlenium.core;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.fluentlenium.core.Fluent;
import org.fluentlenium.core.FluentPage;
import org.fluentlenium.core.annotation.AjaxElement;
import org.fluentlenium.core.annotation.Page;
import org.fluentlenium.core.domain.FluentList;
import org.fluentlenium.core.domain.FluentListImpl;
import org.fluentlenium.core.domain.FluentWebElement;
import org.fluentlenium.core.exception.ConstructionException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.pagefactory.AjaxElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.internal.LocatingElementHandler;

public class FluentAdapter
extends Fluent {
    private final ConcurrentMap<Class, FluentPage> pageInstances = new ConcurrentHashMap<Class, FluentPage>();

    public FluentAdapter(WebDriver webDriver) {
        super(webDriver);
    }

    public FluentAdapter() {
    }

    @Override
    protected void initTest() {
        try {
            this.injectPageIntoContainer(this);
            this.initFluentWebElements(this);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException", e);
        }
    }

    protected void cleanUp() {
        this.pageInstances.clear();
    }

    private void injectPageIntoContainer(Fluent container) throws ClassNotFoundException, IllegalAccessException {
        Class<?> cls = container.getClass();
        while (FluentAdapter.class.isAssignableFrom(cls) || FluentPage.class.isAssignableFrom(cls)) {
            for (Field field : cls.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Page.class)) continue;
                field.setAccessible(true);
                Class<?> clsField = field.getType();
                Class<?> clsPage = Class.forName(clsField.getName());
                Fluent existingPage = (Fluent)this.pageInstances.get(clsPage);
                if (existingPage != null) {
                    field.set(container, existingPage);
                    continue;
                }
                Object page = this.initClass(clsPage, new Object[0]);
                field.set(container, page);
                this.pageInstances.putIfAbsent(clsPage, (FluentPage)page);
                this.injectPageIntoContainer((Fluent)page);
            }
            cls = cls.getSuperclass();
        }
    }

    @Override
    public <T extends FluentPage> T createPage(Class<T> cls, Object ... params) {
        T container = this.initClass(cls, params);
        try {
            this.injectPageIntoContainer((Fluent)container);
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + (cls != null ? cls.getName() : " null") + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + (cls != null ? cls.getName() : " null"), e);
        }
        return container;
    }

    @Override
    protected <T extends FluentPage> T initClass(Class<T> cls, Object ... params) {
        try {
            T page = this.constructPageWithParams(cls, params);
            Class<?> parent = Class.forName(Fluent.class.getName());
            this.initDriver(page, parent);
            this.initBaseUrl(page, parent);
            this.initFluentWebElements(page);
            return page;
        }
        catch (ClassNotFoundException e) {
            throw new ConstructionException("Class " + cls.getName() + "not found", e);
        }
        catch (IllegalAccessException e) {
            throw new ConstructionException("IllegalAccessException on class " + cls.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConstructionException("No constructor found on class " + cls.getName(), e);
        }
        catch (InstantiationException e) {
            throw new ConstructionException("Unable to instantiate " + cls.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConstructionException("Cannot invoke method setDriver on " + cls.getName(), e);
        }
    }

    private <T extends Fluent> void initFluentWebElements(T page) {
        Class<?> classz = page.getClass();
        while (FluentAdapter.class.isAssignableFrom(classz) || FluentPage.class.isAssignableFrom(classz)) {
            for (Field fieldFromPage : classz.getDeclaredFields()) {
                if (!this.isFluentWebElementField(fieldFromPage)) continue;
                fieldFromPage.setAccessible(true);
                AjaxElement elem = fieldFromPage.getAnnotation(AjaxElement.class);
                if (elem == null) {
                    FluentAdapter.proxyElement((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)this.getDriver()), page, fieldFromPage);
                    continue;
                }
                FluentAdapter.proxyElement((ElementLocatorFactory)new AjaxElementLocatorFactory((SearchContext)this.getDriver(), elem.timeOutInSeconds()), page, fieldFromPage);
            }
            classz = classz.getSuperclass();
        }
    }

    private <T extends FluentPage> void initBaseUrl(T page, Class<?> parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.getBaseUrl() == null) {
            return;
        }
        Method m = parent.getDeclaredMethod("withDefaultUrl", String.class);
        m.setAccessible(true);
        m.invoke(page, this.getBaseUrl());
    }

    private <T extends FluentPage> void initDriver(T page, Class<?> parent) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method m = parent.getDeclaredMethod("initFluent", WebDriver.class);
        m.setAccessible(true);
        m.invoke(page, this.getDriver());
    }

    private boolean isFluentWebElementField(Field field) {
        try {
            return !Modifier.isFinal(field.getModifiers()) && (FluentAdapter.isFluentList(field) || field.getType().getConstructor(WebElement.class) != null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isFluentList(Field field) {
        return FluentList.class.isAssignableFrom(field.getType());
    }

    private static void proxyElement(ElementLocatorFactory factory, Object page, Field field) {
        ElementLocator locator = factory.createLocator(field);
        if (locator == null) {
            return;
        }
        try {
            field.setAccessible(true);
            if (FluentAdapter.isFluentList(field)) {
                FluentListInvocationHandler handler = new FluentListInvocationHandler(locator);
                FluentList proxy = (FluentList)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{FluentList.class}, (InvocationHandler)handler);
                field.set(page, proxy);
            } else {
                LocatingElementHandler handler = new LocatingElementHandler(locator);
                WebElement proxy = (WebElement)Proxy.newProxyInstance(page.getClass().getClassLoader(), new Class[]{WebElement.class}, (InvocationHandler)handler);
                field.set(page, field.getType().getConstructor(WebElement.class).newInstance(proxy));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to find an accessible constructor with an argument of type WebElement in " + field.getType(), e);
        }
    }

    public WebDriver getDefaultDriver() {
        return new FirefoxDriver();
    }

    public String getDefaultBaseUrl() {
        return null;
    }

    public void getDefaultConfig() {
    }

    public static void assertAt(FluentPage fluent) {
        fluent.isAt();
    }

    private static class FluentListInvocationHandler
    implements InvocationHandler {
        private final ElementLocator elementLocator;

        public FluentListInvocationHandler(ElementLocator elementLocator) {
            this.elementLocator = elementLocator;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            List elements = this.elementLocator.findElements();
            FluentListImpl list = new FluentListImpl(FluentIterable.from((Iterable)elements).transform((Function)new Function<WebElement, FluentWebElement>(){

                public FluentWebElement apply(WebElement input) {
                    return new FluentWebElement(input);
                }
            }).toList());
            try {
                return method.invoke(list, args);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }
    }
}

