/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.task.conf;

import org.flowable.ui.common.properties.FlowableRestAppProperties;
import org.flowable.ui.common.security.ApiHttpSecurityCustomizer;
import org.flowable.ui.task.properties.FlowableTaskAppProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;

@Configuration(proxyBeanMethods=false)
public class TaskSecurityConfiguration {

    @Configuration
    @Order(value=2)
    public static class TaskApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        protected final FlowableRestAppProperties restAppProperties;
        protected final FlowableTaskAppProperties taskAppProperties;
        protected final ApiHttpSecurityCustomizer apiHttpSecurityCustomizer;

        public TaskApiWebSecurityConfigurationAdapter(FlowableRestAppProperties restAppProperties, FlowableTaskAppProperties taskAppProperties, ApiHttpSecurityCustomizer apiHttpSecurityCustomizer) {
            this.restAppProperties = restAppProperties;
            this.taskAppProperties = taskAppProperties;
            this.apiHttpSecurityCustomizer = apiHttpSecurityCustomizer;
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).csrf().disable();
            if (this.taskAppProperties.isRestEnabled()) {
                if (this.restAppProperties.isVerifyRestApiPrivilege()) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/*-api/**").authorizeRequests().antMatchers(new String[]{"/*-api/**"})).hasAuthority("access-rest-api");
                } else {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/*-api/**").authorizeRequests().antMatchers(new String[]{"/*-api/**"})).authenticated();
                }
                this.apiHttpSecurityCustomizer.customize(http);
            } else {
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.antMatcher("/*-api/**").authorizeRequests().antMatchers(new String[]{"/*-api/**"})).denyAll();
            }
        }
    }
}

