/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.rest.app;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.BaseModelerRestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.domain.ModelHistory;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractModelCmmnResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractModelCmmnResource.class);
    @Autowired
    protected ModelService modelService;

    public void getCaseModelCmmnXml(HttpServletResponse response, String caseModelId) throws IOException {
        if (caseModelId == null) {
            throw new BadRequestException("No case model id provided");
        }
        Model model = this.modelService.getModel(caseModelId);
        this.generateCmmnXml(response, (AbstractModel)model);
    }

    public void getHistoricCaseModelCmmnXml(HttpServletResponse response, String caseModelId, String caseModelHistoryId) throws IOException {
        if (caseModelId == null) {
            throw new BadRequestException("No case model id provided");
        }
        ModelHistory historicModel = this.modelService.getModelHistory(caseModelId, caseModelHistoryId);
        this.generateCmmnXml(response, (AbstractModel)historicModel);
    }

    protected void generateCmmnXml(HttpServletResponse response, AbstractModel model) {
        String name = model.getName().replaceAll(" ", "_");
        response.setHeader("Content-Disposition", "attachment; filename=" + name + ".cmmn.xml");
        if (model.getModelEditorJson() != null) {
            try {
                int count;
                ServletOutputStream servletOutputStream = response.getOutputStream();
                response.setContentType("application/xml");
                CmmnModel cmmnModel = this.modelService.getCmmnModel(model);
                byte[] xmlBytes = this.modelService.getCmmnXML(cmmnModel);
                BufferedInputStream in = new BufferedInputStream(new ByteArrayInputStream(xmlBytes));
                byte[] buffer = new byte[8096];
                while ((count = in.read(buffer)) != -1) {
                    servletOutputStream.write(buffer, 0, count);
                }
                servletOutputStream.flush();
                servletOutputStream.close();
            }
            catch (BaseModelerRestException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Could not generate CMMN XML", (Throwable)e);
                throw new InternalServerErrorException("Could not generate CMMN xml");
            }
        }
    }
}

