/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.dmn.editor.converter.DmnJsonConverter;
import org.flowable.dmn.model.Decision;
import org.flowable.dmn.model.DecisionService;
import org.flowable.dmn.model.DmnDefinition;
import org.flowable.dmn.model.GraphicInfo;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DmnDisplayJsonConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DmnDisplayJsonConverter.class);
    protected DmnJsonConverter dmnJsonConverter = new DmnJsonConverter();
    protected ObjectMapper objectMapper = new ObjectMapper();

    public void processDefinitionElements(AbstractModel decisionServiceModel, ObjectNode displayNode, GraphicInfo diagramInfo) {
        DmnDefinition pojoModel = null;
        if (!StringUtils.isEmpty((CharSequence)decisionServiceModel.getModelEditorJson())) {
            try {
                JsonNode modelNode = this.objectMapper.readTree(decisionServiceModel.getModelEditorJson());
                pojoModel = this.dmnJsonConverter.convertToDmn(modelNode);
            }
            catch (Exception e) {
                LOGGER.error("Error transforming json to pojo {}", (Object)decisionServiceModel.getId(), (Object)e);
            }
        }
        if (pojoModel == null || pojoModel.getLocationMap().isEmpty()) {
            return;
        }
        ArrayNode elementArray = this.objectMapper.createArrayNode();
        ArrayNode flowArray = this.objectMapper.createArrayNode();
        diagramInfo.setX(9999.0);
        diagramInfo.setY(1000.0);
        for (DecisionService decisionService : pojoModel.getDecisionServices()) {
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", decisionService.getId());
            elementNode.put("name", decisionService.getName());
            elementNode.put("type", "DecisionService");
            GraphicInfo graphicInfo = pojoModel.getGraphicInfo(decisionService.getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementArray.add((JsonNode)elementNode);
            this.processDecisionServiceDivider(decisionService.getId(), pojoModel, elementNode);
            Map flowInfo = pojoModel.getFlowLocationMap();
            for (Map.Entry entry : flowInfo.entrySet()) {
                if (!CollectionUtils.isNotEmpty((Collection)((Collection)entry.getValue()))) continue;
                ObjectNode flowNode = this.objectMapper.createObjectNode();
                flowNode.put("id", (String)entry.getKey());
                flowNode.put("type", "InformationRequirement");
                ArrayNode waypointArray = this.objectMapper.createArrayNode();
                for (GraphicInfo flowGraphicInfo : (List)entry.getValue()) {
                    ObjectNode pointNode = this.objectMapper.createObjectNode();
                    this.fillGraphicInfo(pointNode, flowGraphicInfo, false);
                    waypointArray.add((JsonNode)pointNode);
                }
                flowNode.set("waypoints", (JsonNode)waypointArray);
                flowArray.add((JsonNode)flowNode);
            }
        }
        this.processDecisions(pojoModel.getDecisions(), pojoModel, elementArray, diagramInfo);
        displayNode.set("elements", (JsonNode)elementArray);
        displayNode.set("flows", (JsonNode)flowArray);
        displayNode.put("diagramBeginX", diagramInfo.getX());
        displayNode.put("diagramBeginY", diagramInfo.getY());
        displayNode.put("diagramWidth", diagramInfo.getWidth());
        displayNode.put("diagramHeight", diagramInfo.getHeight());
    }

    protected void processDecisions(List<Decision> decisions, DmnDefinition model, ArrayNode elementArray, GraphicInfo diagramInfo) {
        for (Decision decision : decisions) {
            ObjectNode elementNode = this.objectMapper.createObjectNode();
            elementNode.put("id", decision.getId());
            elementNode.put("name", decision.getName());
            elementNode.put("type", "Decision");
            GraphicInfo graphicInfo = model.getGraphicInfo(decision.getId());
            if (graphicInfo != null) {
                this.fillGraphicInfo(elementNode, graphicInfo, true);
                this.fillDiagramInfo(graphicInfo, diagramInfo);
            }
            elementArray.add((JsonNode)elementNode);
        }
    }

    protected void processDecisionServiceDivider(String decisionServiceId, DmnDefinition dmnDefinition, ObjectNode decisionServiceNode) {
        ObjectNode dividerNode = this.objectMapper.createObjectNode();
        dividerNode.put("type", "DecisionServiceDivider");
        decisionServiceNode.set("divider", (JsonNode)dividerNode);
        this.fillWaypoints(decisionServiceId, dmnDefinition, dividerNode);
    }

    protected void fillGraphicInfo(ObjectNode elementNode, GraphicInfo graphicInfo, boolean includeWidthAndHeight) {
        this.commonFillGraphicInfo(elementNode, graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight(), includeWidthAndHeight);
    }

    protected void commonFillGraphicInfo(ObjectNode elementNode, double x, double y, double width, double height, boolean includeWidthAndHeight) {
        elementNode.put("x", x);
        elementNode.put("y", y);
        if (includeWidthAndHeight) {
            elementNode.put("width", width);
            elementNode.put("height", height);
        }
    }

    protected void fillDiagramInfo(GraphicInfo graphicInfo, GraphicInfo diagramInfo) {
        double rightX = graphicInfo.getX() + graphicInfo.getWidth();
        double bottomY = graphicInfo.getY() + graphicInfo.getHeight();
        double middleX = graphicInfo.getX() + graphicInfo.getWidth() / 2.0;
        if (middleX < diagramInfo.getX()) {
            diagramInfo.setX(middleX);
        }
        if (graphicInfo.getY() < diagramInfo.getY()) {
            diagramInfo.setY(graphicInfo.getY());
        }
        if (rightX > diagramInfo.getWidth()) {
            diagramInfo.setWidth(rightX);
        }
        if (bottomY > diagramInfo.getHeight()) {
            diagramInfo.setHeight(bottomY);
        }
    }

    protected void fillWaypoints(String id, DmnDefinition model, ObjectNode elementNode) {
        List flowInfo = model.getDecisionServiceDividerGraphicInfo(id);
        ArrayNode waypointArray = this.objectMapper.createArrayNode();
        for (GraphicInfo graphicInfo : flowInfo) {
            ObjectNode pointNode = this.objectMapper.createObjectNode();
            this.fillGraphicInfo(pointNode, graphicInfo, false);
            waypointArray.add((JsonNode)pointNode);
        }
        elementNode.set("waypoints", (JsonNode)waypointArray);
    }
}

