/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.ExtensionElement;
import org.flowable.cmmn.model.GenericEventListener;
import org.flowable.cmmn.model.SendEventServiceTask;
import org.flowable.eventregistry.model.ChannelEventKeyDetection;
import org.flowable.eventregistry.model.ChannelModel;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.eventregistry.model.JmsInboundChannelModel;
import org.flowable.eventregistry.model.JmsOutboundChannelModel;
import org.flowable.eventregistry.model.KafkaInboundChannelModel;
import org.flowable.eventregistry.model.KafkaOutboundChannelModel;
import org.flowable.eventregistry.model.RabbitInboundChannelModel;
import org.flowable.eventregistry.model.RabbitOutboundChannelModel;

public class CmmnEventModelUtil {
    public static void fillChannelModelMap(List<BaseElement> elements, Map<String, ChannelModel> channelModelMap) {
        for (BaseElement element : elements) {
            String channelKey = CmmnEventModelUtil.getElementValue("channelKey", element);
            String channelType = CmmnEventModelUtil.getElementValue("channelType", element);
            String channelDestination = CmmnEventModelUtil.getElementValue("channelDestination", element);
            if (!StringUtils.isNotEmpty((CharSequence)channelKey) || channelModelMap.containsKey(channelKey) || !StringUtils.isNotEmpty((CharSequence)channelType) || !StringUtils.isNotEmpty((CharSequence)channelDestination)) continue;
            if (element instanceof SendEventServiceTask) {
                CmmnEventModelUtil.createOutboundChannelInMap(channelKey, channelType, channelDestination, element, channelModelMap);
                continue;
            }
            CmmnEventModelUtil.createInboundChannelInMap(channelKey, channelType, channelDestination, "channelName", element, channelModelMap);
        }
    }

    public static void fillEventModelMap(List<BaseElement> elements, Map<String, EventModel> eventModelMap) {
        for (BaseElement element : elements) {
            String eventKey = null;
            if (element instanceof SendEventServiceTask) {
                SendEventServiceTask task = (SendEventServiceTask)element;
                eventKey = task.getEventType();
            } else if (element instanceof GenericEventListener) {
                GenericEventListener genericEventListener = (GenericEventListener)element;
                eventKey = genericEventListener.getEventType();
            } else if (element instanceof Case) {
                Case caseModel = (Case)element;
                eventKey = caseModel.getStartEventType();
            }
            if (!StringUtils.isNotEmpty((CharSequence)eventKey) || eventModelMap.containsKey(eventKey)) continue;
            EventModel eventModel = new EventModel();
            String eventName = CmmnEventModelUtil.getElementValue("eventName", element);
            eventModel.setKey(eventKey);
            if (StringUtils.isNotEmpty((CharSequence)eventName)) {
                eventModel.setName(eventName);
            } else {
                eventModel.setName(eventKey);
            }
            if (element instanceof SendEventServiceTask) {
                SendEventServiceTask task = (SendEventServiceTask)element;
                eventModel.setPayload(CmmnEventModelUtil.getInParameterEventPayload((List)task.getExtensionElements().get("eventInParameter")));
            } else {
                Map<String, EventPayload> payload = CmmnEventModelUtil.getOutParameterEventPayload((List)element.getExtensionElements().get("eventOutParameter"));
                CmmnEventModelUtil.fillEventCorrelationParameters(payload, (List)element.getExtensionElements().get("eventCorrelationParameter"));
                eventModel.setPayload(payload.values());
            }
            eventModelMap.put(eventKey, eventModel);
        }
    }

    protected static void createOutboundChannelInMap(String channelKey, String channelType, String channelDestination, BaseElement elementObject, Map<String, ChannelModel> channelModelMap) {
        JmsOutboundChannelModel channelModel = null;
        if ("jms".equalsIgnoreCase(channelType)) {
            JmsOutboundChannelModel jmsChannelModel = new JmsOutboundChannelModel();
            jmsChannelModel.setDestination(channelDestination);
            channelModel = jmsChannelModel;
        } else if ("kafka".equalsIgnoreCase(channelType)) {
            KafkaOutboundChannelModel kafkaChannelModel = new KafkaOutboundChannelModel();
            kafkaChannelModel.setTopic(channelDestination);
            channelModel = kafkaChannelModel;
        } else if ("rabbitmq".equalsIgnoreCase(channelType)) {
            RabbitOutboundChannelModel rabbitChannelModel = new RabbitOutboundChannelModel();
            rabbitChannelModel.setRoutingKey(channelDestination);
            channelModel = rabbitChannelModel;
        }
        String channelName = CmmnEventModelUtil.getElementValue("channelName", elementObject);
        channelModel.setKey(channelKey);
        if (StringUtils.isNotEmpty((CharSequence)channelName)) {
            channelModel.setName(channelName);
        } else {
            channelModel.setName(channelKey);
        }
        channelModel.setChannelType("outbound");
        String serializerType = CmmnEventModelUtil.getElementValue("serializerType", elementObject);
        if (StringUtils.isEmpty((CharSequence)serializerType)) {
            serializerType = "json";
        }
        channelModel.setSerializerType(serializerType);
        channelModelMap.put(channelKey, (ChannelModel)channelModel);
    }

    protected static void createInboundChannelInMap(String channelKey, String channelType, String channelDestination, String channelNameProperty, BaseElement elementObject, Map<String, ChannelModel> channelModelMap) {
        JmsInboundChannelModel channelModel = null;
        if ("jms".equalsIgnoreCase(channelType)) {
            JmsInboundChannelModel jmsChannelModel = new JmsInboundChannelModel();
            jmsChannelModel.setDestination(channelDestination);
            channelModel = jmsChannelModel;
        } else if ("kafka".equalsIgnoreCase(channelType)) {
            KafkaInboundChannelModel kafkaChannelModel = new KafkaInboundChannelModel();
            kafkaChannelModel.setTopics(Collections.singletonList(channelDestination));
            channelModel = kafkaChannelModel;
        } else if ("rabbitmq".equalsIgnoreCase(channelType)) {
            RabbitInboundChannelModel rabbitChannelModel = new RabbitInboundChannelModel();
            rabbitChannelModel.setQueues(Collections.singletonList(channelDestination));
            channelModel = rabbitChannelModel;
        }
        String channelName = CmmnEventModelUtil.getElementValue(channelNameProperty, elementObject);
        channelModel.setKey(channelKey);
        if (StringUtils.isNotEmpty((CharSequence)channelName)) {
            channelModel.setName(channelName);
        } else {
            channelModel.setName(channelKey);
        }
        channelModel.setChannelType("inbound");
        String deserializerType = CmmnEventModelUtil.getElementValue("deserializerType", elementObject);
        if (StringUtils.isEmpty((CharSequence)deserializerType)) {
            deserializerType = "json";
        }
        channelModel.setDeserializerType(deserializerType);
        String keyDetectionType = CmmnEventModelUtil.getElementValue("keyDetectionType", elementObject);
        String keyDetectionValue = CmmnEventModelUtil.getElementValue("keyDetectionValue", elementObject);
        if (StringUtils.isNotEmpty((CharSequence)keyDetectionType) && StringUtils.isNotEmpty((CharSequence)keyDetectionValue)) {
            ChannelEventKeyDetection channelEventKeyDetection = new ChannelEventKeyDetection();
            if ("fixedValue".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setFixedValue(keyDetectionValue);
            } else if ("jsonField".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setJsonField(keyDetectionValue);
            } else if ("jsonPointer".equalsIgnoreCase(keyDetectionType)) {
                channelEventKeyDetection.setJsonPointerExpression(keyDetectionValue);
            }
            channelModel.setChannelEventKeyDetection(channelEventKeyDetection);
        }
        channelModelMap.put(channelKey, (ChannelModel)channelModel);
    }

    protected static Map<String, EventPayload> getOutParameterEventPayload(List<ExtensionElement> parameterList) {
        LinkedHashMap<String, EventPayload> eventPayload = new LinkedHashMap<String, EventPayload>();
        if (parameterList != null && parameterList.size() > 0) {
            for (ExtensionElement parameterElement : parameterList) {
                String name = parameterElement.getAttributeValue(null, "source");
                String type = parameterElement.getAttributeValue(null, "sourceType");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                eventPayload.put(name, new EventPayload(name, type));
            }
        }
        return eventPayload;
    }

    protected static List<EventPayload> getInParameterEventPayload(List<ExtensionElement> parameterList) {
        ArrayList<EventPayload> eventPayloadList = new ArrayList<EventPayload>();
        if (parameterList != null && parameterList.size() > 0) {
            for (ExtensionElement parameterElement : parameterList) {
                String name = parameterElement.getAttributeValue(null, "target");
                String type = parameterElement.getAttributeValue(null, "targetType");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                eventPayloadList.add(new EventPayload(name, type));
            }
        }
        return eventPayloadList;
    }

    protected static void fillEventCorrelationParameters(Map<String, EventPayload> currentPayload, List<ExtensionElement> parameterList) {
        if (parameterList != null && parameterList.size() > 0) {
            for (ExtensionElement parameterElement : parameterList) {
                EventPayload eventPayload;
                String name = parameterElement.getAttributeValue(null, "name");
                String type = parameterElement.getAttributeValue(null, "type");
                if (StringUtils.isEmpty((CharSequence)type)) {
                    type = "string";
                }
                if ((eventPayload = currentPayload.get(name)) != null) {
                    eventPayload.setCorrelationParameter(true);
                    continue;
                }
                currentPayload.put(name, EventPayload.correlation((String)name, (String)type));
            }
        }
    }

    protected static String getElementValue(String name, BaseElement elementObject) {
        List elementList = (List)elementObject.getExtensionElements().get(name);
        if (elementList != null && elementList.size() > 0) {
            return ((ExtensionElement)elementList.get(0)).getElementText();
        }
        return null;
    }
}

