/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.modeler.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.cmmn.editor.json.converter.CmmnJsonConverter;
import org.flowable.cmmn.editor.json.model.CmmnModelInfo;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.editor.language.json.converter.BpmnJsonConverter;
import org.flowable.editor.language.json.converter.util.CollectionUtils;
import org.flowable.editor.language.json.model.ModelInfo;
import org.flowable.idm.api.User;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.exception.BadRequestException;
import org.flowable.ui.common.service.exception.InternalServerErrorException;
import org.flowable.ui.modeler.domain.AbstractModel;
import org.flowable.ui.modeler.domain.AppDefinition;
import org.flowable.ui.modeler.domain.AppModelDefinition;
import org.flowable.ui.modeler.domain.Model;
import org.flowable.ui.modeler.model.AppDefinitionPublishRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionRepresentation;
import org.flowable.ui.modeler.model.AppDefinitionUpdateResultRepresentation;
import org.flowable.ui.modeler.repository.ModelRepository;
import org.flowable.ui.modeler.service.AppDefinitionPublishService;
import org.flowable.ui.modeler.service.DecisionTableModelConversionUtil;
import org.flowable.ui.modeler.serviceapi.ModelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class AppDefinitionImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AppDefinitionImportService.class);
    @Autowired
    protected AppDefinitionPublishService appDefinitionPublishService;
    @Autowired
    protected ModelService modelService;
    @Autowired
    protected ModelRepository modelRepository;
    @Autowired
    protected ObjectMapper objectMapper;
    protected BpmnJsonConverter bpmnJsonConverter = new BpmnJsonConverter();
    protected CmmnJsonConverter cmmnJsonConverter = new CmmnJsonConverter();

    public AppDefinitionRepresentation importAppDefinition(HttpServletRequest request, MultipartFile file) {
        try {
            InputStream is = file.getInputStream();
            String fileName = file.getOriginalFilename();
            return this.importAppDefinition(request, is, fileName, null, null, null, null, null);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error loading file", (Throwable)e);
        }
    }

    public AppDefinitionRepresentation importAppDefinitionNewVersion(HttpServletRequest request, MultipartFile file, String appDefId) {
        try {
            List<Model> referencedModels;
            InputStream is = file.getInputStream();
            String fileName = file.getOriginalFilename();
            Model appModel = this.modelService.getModel(appDefId);
            if (!appModel.getModelType().equals(3)) {
                throw new BadRequestException("No app definition found for id " + appDefId);
            }
            AppDefinitionRepresentation appDefinition = this.createAppDefinitionRepresentation(appModel);
            HashMap<String, Model> existingProcessModelMap = new HashMap<String, Model>();
            HashMap<String, Model> existingCaseModelMap = new HashMap<String, Model>();
            HashMap<String, Model> existingFormModelMap = new HashMap<String, Model>();
            HashMap<String, Model> existingDecisionTableMap = new HashMap<String, Model>();
            if (appDefinition.getDefinition() != null && CollectionUtils.isNotEmpty(appDefinition.getDefinition().getModels())) {
                for (AppModelDefinition modelDef : appDefinition.getDefinition().getModels()) {
                    Model processModel = this.modelService.getModel(modelDef.getId());
                    referencedModels = this.modelRepository.findByParentModelId(processModel.getId());
                    for (Model childModel : referencedModels) {
                        if (2 == childModel.getModelType()) {
                            existingFormModelMap.put(childModel.getKey(), childModel);
                            continue;
                        }
                        if (4 != childModel.getModelType()) continue;
                        existingDecisionTableMap.put(childModel.getKey(), childModel);
                    }
                    existingProcessModelMap.put(processModel.getKey(), processModel);
                }
            }
            if (appDefinition.getDefinition() != null && CollectionUtils.isNotEmpty(appDefinition.getDefinition().getCmmnModels())) {
                for (AppModelDefinition modelDef : appDefinition.getDefinition().getCmmnModels()) {
                    Model caseModel = this.modelService.getModel(modelDef.getId());
                    referencedModels = this.modelRepository.findByParentModelId(caseModel.getId());
                    for (Model childModel : referencedModels) {
                        if (2 == childModel.getModelType()) {
                            existingFormModelMap.put(childModel.getKey(), childModel);
                            continue;
                        }
                        if (4 != childModel.getModelType()) continue;
                        existingDecisionTableMap.put(childModel.getKey(), childModel);
                    }
                    existingCaseModelMap.put(caseModel.getKey(), caseModel);
                }
            }
            return this.importAppDefinition(request, is, fileName, appModel, existingProcessModelMap, existingCaseModelMap, existingFormModelMap, existingDecisionTableMap);
        }
        catch (IOException e) {
            throw new InternalServerErrorException("Error loading file", (Throwable)e);
        }
    }

    protected AppDefinitionRepresentation importAppDefinition(HttpServletRequest request, InputStream is, String fileName, Model existingAppModel, Map<String, Model> existingProcessModelMap, Map<String, Model> existingCaseModelMap, Map<String, Model> existingFormModelMap, Map<String, Model> existingDecisionTableModelMap) {
        if (fileName != null && fileName.endsWith(".zip")) {
            HashMap<String, String> formMap = new HashMap<String, String>();
            HashMap<String, String> decisionTableMap = new HashMap<String, String>();
            HashMap<String, String> bpmnModelMap = new HashMap<String, String>();
            HashMap<String, String> cmmnModelMap = new HashMap<String, String>();
            HashMap<String, byte[]> thumbnailMap = new HashMap<String, byte[]>();
            Model appDefinitionModel = this.readZipFile(is, formMap, decisionTableMap, bpmnModelMap, cmmnModelMap, thumbnailMap);
            if (StringUtils.isNotEmpty((CharSequence)appDefinitionModel.getKey()) && StringUtils.isNotEmpty((CharSequence)appDefinitionModel.getModelEditorJson())) {
                Map<String, Model> formKeyAndModelMap = this.importForms(formMap, thumbnailMap, existingFormModelMap);
                Map<String, Model> decisionTableKeyAndModelMap = this.importDecisionTables(decisionTableMap, thumbnailMap, existingDecisionTableModelMap);
                Map<String, Model> bpmnModelIdAndModelMap = this.importBpmnModels(bpmnModelMap, formKeyAndModelMap, decisionTableKeyAndModelMap, thumbnailMap, existingProcessModelMap);
                Map<String, Model> cmmnModelIdAndModelMap = this.importCmmnModels(cmmnModelMap, formKeyAndModelMap, decisionTableKeyAndModelMap, thumbnailMap, existingCaseModelMap);
                AppDefinitionRepresentation result = this.importAppDefinitionModel(appDefinitionModel, existingAppModel, bpmnModelIdAndModelMap, cmmnModelIdAndModelMap);
                return result;
            }
            throw new BadRequestException("Could not find app definition json");
        }
        throw new BadRequestException("Invalid file name, only .zip files are supported not " + fileName);
    }

    public AppDefinitionUpdateResultRepresentation publishAppDefinition(String modelId, AppDefinitionPublishRepresentation publishModel) {
        User user = SecurityUtils.getCurrentUserObject();
        Model appModel = this.modelService.getModel(modelId);
        AppDefinitionRepresentation appDefinitionRepresentation = this.createAppDefinitionRepresentation(appModel);
        AppDefinitionUpdateResultRepresentation result = new AppDefinitionUpdateResultRepresentation();
        this.appDefinitionPublishService.publishAppDefinition(publishModel.getComment(), appModel, user);
        result.setAppDefinition(appDefinitionRepresentation);
        return result;
    }

    protected AppDefinitionRepresentation createAppDefinitionRepresentation(AbstractModel model) {
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(model.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing app {}", (Object)model.getId(), (Object)e);
            throw new InternalServerErrorException("Could not deserialize app definition");
        }
        AppDefinitionRepresentation result = new AppDefinitionRepresentation(model);
        result.setDefinition(appDefinition);
        return result;
    }

    protected Model readZipFile(InputStream inputStream, Map<String, String> formMap, Map<String, String> decisionTableMap, Map<String, String> bpmnModelMap, Map<String, String> cmmnModelMap, Map<String, byte[]> thumbnailMap) {
        Model appDefinitionModel = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                if (zipEntryName.endsWith("json") || zipEntryName.endsWith("png")) {
                    String modelFileName = null;
                    modelFileName = zipEntryName.contains("/") ? zipEntryName.substring(zipEntryName.indexOf(47) + 1) : zipEntryName;
                    if (modelFileName.endsWith(".png")) {
                        thumbnailMap.put(modelFileName.replace(".png", ""), IOUtils.toByteArray((InputStream)zipInputStream));
                    } else {
                        modelFileName = modelFileName.replace(".json", "");
                        String json = IOUtils.toString((InputStream)zipInputStream, (String)"utf-8");
                        if (zipEntryName.startsWith("bpmn-models/")) {
                            bpmnModelMap.put(modelFileName, json);
                        } else if (zipEntryName.startsWith("cmmn-models/")) {
                            cmmnModelMap.put(modelFileName, json);
                        } else if (zipEntryName.startsWith("form-models/")) {
                            formMap.put(modelFileName, json);
                        } else if (zipEntryName.startsWith("decision-table-models/")) {
                            decisionTableMap.put(modelFileName, json);
                        } else if (!zipEntryName.contains("/")) {
                            appDefinitionModel = this.createModelObject(json, 3);
                        }
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error reading app definition zip file", (Throwable)e);
            throw new InternalServerErrorException("Error reading app definition zip file");
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.closeEntry();
                }
                catch (Exception exception) {}
                try {
                    zipInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return appDefinitionModel;
    }

    protected Map<String, Model> importForms(Map<String, String> formMap, Map<String, byte[]> thumbnailMap, Map<String, Model> existingFormModelMap) {
        HashMap<String, Model> oldFormIdAndModelMap = new HashMap<String, Model>();
        for (String formKey : formMap.keySet()) {
            Model formModel = this.createModelObject(formMap.get(formKey), 2);
            String oldFormId = formModel.getId();
            Model existingModel = null;
            if (existingFormModelMap != null && existingFormModelMap.containsKey(formModel.getKey())) {
                existingModel = existingFormModelMap.get(formModel.getKey());
            }
            Model updatedFormModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(formKey)) {
                    imageBytes = thumbnailMap.get(formKey);
                }
                updatedFormModel = this.modelService.saveModel(existingModel, formModel.getModelEditorJson(), imageBytes, true, "App definition import", SecurityUtils.getCurrentUserObject());
            } else {
                formModel.setId(null);
                updatedFormModel = this.modelService.createModel(formModel, SecurityUtils.getCurrentUserObject());
                if (thumbnailMap.containsKey(formKey)) {
                    updatedFormModel.setThumbnail(thumbnailMap.get(formKey));
                    this.modelRepository.save(updatedFormModel);
                }
            }
            oldFormIdAndModelMap.put(oldFormId, updatedFormModel);
        }
        return oldFormIdAndModelMap;
    }

    protected Map<String, Model> importDecisionTables(Map<String, String> decisionTableMap, Map<String, byte[]> thumbnailMap, Map<String, Model> existingDecisionTableMap) {
        HashMap<String, Model> oldDecisionTableIdAndModelMap = new HashMap<String, Model>();
        for (String decisionTableKey : decisionTableMap.keySet()) {
            Model decisionTableModel = this.createModelObject(decisionTableMap.get(decisionTableKey), 4);
            DecisionTableModelConversionUtil.convertModelToV3(decisionTableModel);
            String oldDecisionTableId = decisionTableModel.getId();
            Model existingModel = null;
            if (existingDecisionTableMap != null && existingDecisionTableMap.containsKey(decisionTableModel.getKey())) {
                existingModel = existingDecisionTableMap.get(decisionTableModel.getKey());
            }
            Model updatedDecisionTableModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(decisionTableKey)) {
                    imageBytes = thumbnailMap.get(decisionTableKey);
                }
                updatedDecisionTableModel = this.modelService.saveModel(existingModel, decisionTableModel.getModelEditorJson(), imageBytes, true, "App definition import", SecurityUtils.getCurrentUserObject());
            } else {
                decisionTableModel.setId(null);
                updatedDecisionTableModel = this.modelService.createModel(decisionTableModel, SecurityUtils.getCurrentUserObject());
                if (thumbnailMap.containsKey(decisionTableKey)) {
                    updatedDecisionTableModel.setThumbnail(thumbnailMap.get(decisionTableKey));
                    this.modelRepository.save(updatedDecisionTableModel);
                }
            }
            oldDecisionTableIdAndModelMap.put(oldDecisionTableId, updatedDecisionTableModel);
        }
        return oldDecisionTableIdAndModelMap;
    }

    protected Map<String, Model> importBpmnModels(Map<String, String> bpmnModelMap, Map<String, Model> formKeyAndModelMap, Map<String, Model> decisionTableKeyAndModelMap, Map<String, byte[]> thumbnailMap, Map<String, Model> existingProcessModelMap) {
        HashMap<String, Model> bpmnModelIdAndModelMap = new HashMap<String, Model>();
        for (String bpmnModelKey : bpmnModelMap.keySet()) {
            Model existingModel = null;
            if (existingProcessModelMap != null && existingProcessModelMap.containsKey(bpmnModelKey)) {
                existingModel = existingProcessModelMap.get(bpmnModelKey);
            }
            String bpmnModelJson = bpmnModelMap.get(bpmnModelKey);
            Model bpmnModelObject = this.createModelObject(bpmnModelJson, 0);
            String oldBpmnModelId = bpmnModelObject.getId();
            JsonNode bpmnModelNode = null;
            try {
                bpmnModelNode = this.objectMapper.readTree(bpmnModelObject.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Error reading BPMN json for {}", (Object)bpmnModelKey, (Object)e);
                throw new InternalServerErrorException("Error reading BPMN json for " + bpmnModelKey);
            }
            HashMap<String, String> oldFormIdFormKeyMap = new HashMap<String, String>();
            HashMap<String, ModelInfo> formKeyModelIdMap = new HashMap<String, ModelInfo>();
            for (String oldFormId : formKeyAndModelMap.keySet()) {
                Model formModel = formKeyAndModelMap.get(oldFormId);
                oldFormIdFormKeyMap.put(oldFormId, formModel.getKey());
                formKeyModelIdMap.put(formModel.getKey(), new ModelInfo(formModel.getId(), formModel.getName(), formModel.getKey()));
            }
            HashMap<String, String> oldDecisionTableIdDecisionTableKeyMap = new HashMap<String, String>();
            HashMap<String, ModelInfo> decisionTableKeyModelIdMap = new HashMap<String, ModelInfo>();
            for (String oldDecisionTableId : decisionTableKeyAndModelMap.keySet()) {
                Model decisionTableModel = decisionTableKeyAndModelMap.get(oldDecisionTableId);
                oldDecisionTableIdDecisionTableKeyMap.put(oldDecisionTableId, decisionTableModel.getKey());
                decisionTableKeyModelIdMap.put(decisionTableModel.getKey(), new ModelInfo(decisionTableModel.getId(), decisionTableModel.getName(), decisionTableModel.getKey()));
            }
            BpmnModel bpmnModel = this.bpmnJsonConverter.convertToBpmnModel(bpmnModelNode, oldFormIdFormKeyMap, oldDecisionTableIdDecisionTableKeyMap);
            String updatedBpmnJson = this.bpmnJsonConverter.convertToJson(bpmnModel, formKeyModelIdMap, decisionTableKeyModelIdMap).toString();
            Model updatedProcessModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(bpmnModelKey)) {
                    imageBytes = thumbnailMap.get(bpmnModelKey);
                }
                existingModel.setModelEditorJson(updatedBpmnJson);
                updatedProcessModel = this.modelService.saveModel(existingModel, existingModel.getModelEditorJson(), imageBytes, true, "App definition import", SecurityUtils.getCurrentUserObject());
            } else {
                bpmnModelObject.setId(null);
                bpmnModelObject.setModelEditorJson(updatedBpmnJson);
                updatedProcessModel = this.modelService.createModel(bpmnModelObject, SecurityUtils.getCurrentUserObject());
                if (thumbnailMap.containsKey(bpmnModelKey)) {
                    updatedProcessModel.setThumbnail(thumbnailMap.get(bpmnModelKey));
                    this.modelService.saveModel(updatedProcessModel);
                }
            }
            bpmnModelIdAndModelMap.put(oldBpmnModelId, updatedProcessModel);
        }
        return bpmnModelIdAndModelMap;
    }

    protected Map<String, Model> importCmmnModels(Map<String, String> cmmnModelMap, Map<String, Model> formKeyAndModelMap, Map<String, Model> decisionTableKeyAndModelMap, Map<String, byte[]> thumbnailMap, Map<String, Model> existingCaseModelMap) {
        HashMap<String, Model> cmmnModelIdAndModelMap = new HashMap<String, Model>();
        for (String cmmnModelKey : cmmnModelMap.keySet()) {
            Model existingModel = null;
            if (existingCaseModelMap != null && existingCaseModelMap.containsKey(cmmnModelKey)) {
                existingModel = existingCaseModelMap.get(cmmnModelKey);
            }
            String cmmnModelJson = cmmnModelMap.get(cmmnModelKey);
            Model cmmnModelObject = this.createModelObject(cmmnModelJson, 5);
            String oldCmmnModelId = cmmnModelObject.getId();
            JsonNode cmmnModelNode = null;
            try {
                cmmnModelNode = this.objectMapper.readTree(cmmnModelObject.getModelEditorJson());
            }
            catch (Exception e) {
                LOGGER.error("Error reading CMMN json for {}", (Object)cmmnModelKey, (Object)e);
                throw new InternalServerErrorException("Error reading CMMN json for " + cmmnModelKey);
            }
            HashMap<String, String> oldFormIdFormKeyMap = new HashMap<String, String>();
            HashMap<String, CmmnModelInfo> formKeyModelIdMap = new HashMap<String, CmmnModelInfo>();
            for (String oldFormId : formKeyAndModelMap.keySet()) {
                Model formModel = formKeyAndModelMap.get(oldFormId);
                oldFormIdFormKeyMap.put(oldFormId, formModel.getKey());
                formKeyModelIdMap.put(formModel.getKey(), new CmmnModelInfo(formModel.getId(), formModel.getName(), formModel.getKey()));
            }
            HashMap<String, String> oldDecisionTableIdDecisionTableKeyMap = new HashMap<String, String>();
            HashMap<String, CmmnModelInfo> decisionTableKeyModelIdMap = new HashMap<String, CmmnModelInfo>();
            for (String oldDecisionTableId : decisionTableKeyAndModelMap.keySet()) {
                Model decisionTableModel = decisionTableKeyAndModelMap.get(oldDecisionTableId);
                oldDecisionTableIdDecisionTableKeyMap.put(oldDecisionTableId, decisionTableModel.getKey());
                decisionTableKeyModelIdMap.put(decisionTableModel.getKey(), new CmmnModelInfo(decisionTableModel.getId(), decisionTableModel.getName(), decisionTableModel.getKey()));
            }
            CmmnModel cmmnModel = this.cmmnJsonConverter.convertToCmmnModel(cmmnModelNode, oldFormIdFormKeyMap, oldDecisionTableIdDecisionTableKeyMap, null, null);
            String updatedCmmnJson = this.cmmnJsonConverter.convertToJson(cmmnModel, formKeyModelIdMap, decisionTableKeyModelIdMap).toString();
            Model updatedCaseModel = null;
            if (existingModel != null) {
                byte[] imageBytes = null;
                if (thumbnailMap.containsKey(cmmnModelKey)) {
                    imageBytes = thumbnailMap.get(cmmnModelKey);
                }
                existingModel.setModelEditorJson(updatedCmmnJson);
                updatedCaseModel = this.modelService.saveModel(existingModel, existingModel.getModelEditorJson(), imageBytes, true, "App definition import", SecurityUtils.getCurrentUserObject());
            } else {
                cmmnModelObject.setId(null);
                cmmnModelObject.setModelEditorJson(updatedCmmnJson);
                updatedCaseModel = this.modelService.createModel(cmmnModelObject, SecurityUtils.getCurrentUserObject());
                if (thumbnailMap.containsKey(cmmnModelKey)) {
                    updatedCaseModel.setThumbnail(thumbnailMap.get(cmmnModelKey));
                    this.modelService.saveModel(updatedCaseModel);
                }
            }
            cmmnModelIdAndModelMap.put(oldCmmnModelId, updatedCaseModel);
        }
        return cmmnModelIdAndModelMap;
    }

    protected AppDefinitionRepresentation importAppDefinitionModel(Model appDefinitionModel, Model existingAppModel, Map<String, Model> bpmnModelIdAndModelMap, Map<String, Model> cmmnModelIdAndModelMap) {
        Model newModel;
        AppDefinition appDefinition = null;
        try {
            appDefinition = (AppDefinition)this.objectMapper.readValue(appDefinitionModel.getModelEditorJson(), AppDefinition.class);
        }
        catch (Exception e) {
            LOGGER.error("Error reading app definition {}", (Object)appDefinitionModel.getName(), (Object)e);
            throw new BadRequestException("Error reading app definition", (Throwable)e);
        }
        if (appDefinition.getModels() != null) {
            for (AppModelDefinition modelDef : appDefinition.getModels()) {
                if (!bpmnModelIdAndModelMap.containsKey(modelDef.getId())) continue;
                newModel = bpmnModelIdAndModelMap.get(modelDef.getId());
                modelDef.setId(newModel.getId());
                modelDef.setName(newModel.getName());
                modelDef.setCreatedBy(newModel.getCreatedBy());
                modelDef.setLastUpdatedBy(newModel.getLastUpdatedBy());
                modelDef.setLastUpdated(newModel.getLastUpdated());
                modelDef.setVersion(newModel.getVersion());
            }
        }
        if (appDefinition.getCmmnModels() != null) {
            for (AppModelDefinition modelDef : appDefinition.getCmmnModels()) {
                if (!cmmnModelIdAndModelMap.containsKey(modelDef.getId())) continue;
                newModel = cmmnModelIdAndModelMap.get(modelDef.getId());
                modelDef.setId(newModel.getId());
                modelDef.setName(newModel.getName());
                modelDef.setCreatedBy(newModel.getCreatedBy());
                modelDef.setLastUpdatedBy(newModel.getLastUpdatedBy());
                modelDef.setLastUpdated(newModel.getLastUpdated());
                modelDef.setVersion(newModel.getVersion());
            }
        }
        try {
            String updatedAppDefinitionJson = this.objectMapper.writeValueAsString((Object)appDefinition);
            if (existingAppModel != null) {
                appDefinitionModel = this.modelService.saveModel(existingAppModel, updatedAppDefinitionJson, null, true, "App definition import", SecurityUtils.getCurrentUserObject());
            } else {
                appDefinitionModel.setId(null);
                appDefinitionModel.setModelEditorJson(updatedAppDefinitionJson);
                appDefinitionModel = this.modelService.createModel(appDefinitionModel, SecurityUtils.getCurrentUserObject());
            }
            AppDefinitionRepresentation result = new AppDefinitionRepresentation(appDefinitionModel);
            result.setDefinition(appDefinition);
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error storing app definition", (Throwable)e);
            throw new InternalServerErrorException("Error storing app definition");
        }
    }

    protected Model createModelObject(String modelJson, int modelType) {
        try {
            JsonNode modelNode = this.objectMapper.readTree(modelJson);
            Model model = new Model();
            model.setId(modelNode.get("id").asText());
            model.setName(modelNode.get("name").asText());
            model.setKey(modelNode.get("key").asText());
            JsonNode descriptionNode = modelNode.get("description");
            if (descriptionNode != null && !descriptionNode.isNull()) {
                model.setDescription(descriptionNode.asText());
            }
            model.setModelEditorJson(modelNode.get("editorJson").toString());
            model.setModelType(modelType);
            return model;
        }
        catch (Exception e) {
            LOGGER.error("Error reading model json", (Throwable)e);
            throw new InternalServerErrorException("Error reading model json");
        }
    }
}

