/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.idm.rest.api;

import java.util.ArrayList;
import java.util.List;
import org.flowable.idm.api.Group;
import org.flowable.ui.common.model.GroupRepresentation;
import org.flowable.ui.common.service.exception.NotFoundException;
import org.flowable.ui.idm.service.GroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ApiGroupsResource {
    @Autowired
    protected GroupService groupService;

    @GetMapping(value={"/groups/{groupId}"}, produces={"application/json"})
    public GroupRepresentation getGroupInformation(@PathVariable String groupId) {
        Group group = this.groupService.getGroup(groupId);
        if (group != null) {
            return new GroupRepresentation(group);
        }
        throw new NotFoundException();
    }

    @GetMapping(value={"/groups"}, produces={"application/json"})
    public List<GroupRepresentation> findGroupsByFilter(@RequestParam(value="filter") String filter) {
        ArrayList<GroupRepresentation> result = new ArrayList<GroupRepresentation>();
        List groups = this.groupService.getGroups(filter);
        for (Group group : groups) {
            result.add(new GroupRepresentation(group));
        }
        return result;
    }
}

