/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.service.idm.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.flowable.ui.common.properties.FlowableCommonAppProperties;
import org.flowable.ui.common.service.idm.cache.UserCache;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public abstract class BaseUserCache
implements UserCache {
    protected final FlowableCommonAppProperties properties;
    protected LoadingCache<String, UserCache.CachedUser> userCache;

    protected BaseUserCache(FlowableCommonAppProperties properties) {
        this.properties = properties;
    }

    @PostConstruct
    protected void initCache() {
        FlowableCommonAppProperties.Cache cache = this.properties.getCacheUsers();
        long userCacheMaxSize = cache.getMaxSize();
        long userCacheMaxAge = cache.getMaxAge();
        this.userCache = CacheBuilder.newBuilder().maximumSize(userCacheMaxSize).expireAfterAccess(userCacheMaxAge, TimeUnit.SECONDS).recordStats().build((CacheLoader)new CacheLoader<String, UserCache.CachedUser>(){

            public UserCache.CachedUser load(String userId) throws Exception {
                return BaseUserCache.this.loadUser(userId);
            }
        });
    }

    protected abstract UserCache.CachedUser loadUser(String var1);

    @Override
    public void putUser(String userId, UserCache.CachedUser cachedUser) {
        this.userCache.put((Object)userId, (Object)cachedUser);
    }

    @Override
    public UserCache.CachedUser getUser(String userId) {
        return this.getUser(userId, false, false, true);
    }

    @Override
    public UserCache.CachedUser getUser(String userId, boolean throwExceptionOnNotFound, boolean throwExceptionOnInactive, boolean checkValidity) {
        try {
            UserCache.CachedUser cachedUser = (UserCache.CachedUser)this.userCache.get((Object)userId);
            return cachedUser;
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (UncheckedExecutionException uee) {
            if (uee.getCause() instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)uee.getCause();
                if (runtimeException instanceof UsernameNotFoundException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
                if (runtimeException instanceof LockedException) {
                    if (throwExceptionOnNotFound) {
                        throw runtimeException;
                    }
                    return null;
                }
            }
            throw uee;
        }
    }

    @Override
    public void invalidate(String userId) {
        this.userCache.invalidate((Object)userId);
    }
}

