/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.ui.common.security;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.flowable.ui.common.model.RemoteGroup;
import org.flowable.ui.common.model.RemoteUser;
import org.flowable.ui.common.security.SecurityUtils;
import org.flowable.ui.common.service.idm.RemoteIdmService;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class RemoteIdmUserDetailsService
implements UserDetailsService {
    protected final RemoteIdmService remoteIdmService;

    public RemoteIdmUserDetailsService(RemoteIdmService remoteIdmService) {
        this.remoteIdmService = remoteIdmService;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        RemoteUser user = this.remoteIdmService.getUser(username);
        if (user == null) {
            throw new UsernameNotFoundException("user not found " + username);
        }
        ArrayList<Object> grantedAuthorities = new ArrayList<Object>();
        for (String privilege : user.getPrivileges()) {
            grantedAuthorities.add(new SimpleGrantedAuthority(privilege));
        }
        for (RemoteGroup group : user.getGroups()) {
            grantedAuthorities.add(SecurityUtils.createGroupAuthority(group.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)user.getTenantId())) {
            grantedAuthorities.add(SecurityUtils.createTenantAuthority(user.getTenantId()));
        }
        return User.withUsername((String)user.getId()).password("").authorities(grantedAuthorities).build();
    }
}

